﻿//==============================================================================
//
//  Main entry for AsmSIMD
//
//==============================================================================

#include "stdafx.h"
#include <stdio.h>

extern      unsigned __int128 simd_test( void* Vec0, void* Vec1, void* Vec2, void* Vec3 );

extern "C"  void cTest();
extern "C"  unsigned __int128 simd_test_c(void* Vec0, void* Vec1, void* Vec2, void* Vec3);

union VECTOR_REGISTER
{
    unsigned __int128   Q[1];
    uint64_t            X[2];
    uint32_t            W[4];
    uint16_t            H[8];
    uint8_t             B[16];
    double              D[2];
    float               S[4];
};

float simd_ex0() // Examples of name mangling and call frame generation
{
    return( 0 );
}

double simd_ex1( uint64_t Immed )
{
    return( (double)Immed );
}

uint8_t simd_ex1v( void* pV1 )
{
    return( 0 );
}

uint16_t simd_ex2v( void* pV1, void* pV2 )
{
    return( 0 );
}

uint32_t simd_ex3v( void* pV1, void* pV2, void* pV3 )
{
    return( 0 );
}

uint64_t simd_ex4v( void* pV1, void* pV2, void* pV3, void* pV4 )
{
    return( 0 );
}

int simd_ex4i( int64_t a, int32_t b, int16_t c, int8_t )
{
    return( 0 );
}

long simd_ex4u( uint64_t a, uint32_t b, uint16_t c, uint8_t )
{
    return( 0 );
}

__int128 simd_exq( __int128 Immed )
{
    return( Immed );
}

#ifdef NN_NINTENDO_SDK
extern "C" void nnMain( int argc, char **argv )
#else
int main( int argc, char **argv )
#endif
{
#ifdef NN_NINTENDO_SDK
    //Get our args
    //int argc = nn::GetArgc();
    //char** argv = nn::GetArgv();
#endif
    for(int ArgIndex = 0; ArgIndex < argc; ArgIndex += 1 )
    {
        REPORT( "Command line arg %d:  %s\n", ArgIndex, argv[ArgIndex] );
    }

    cTest();    // Call C version of test

    VECTOR_REGISTER Vec0;
    VECTOR_REGISTER Vec1;
    VECTOR_REGISTER Vec2;
    VECTOR_REGISTER Vec3;
    VECTOR_REGISTER RetVal;

    Vec0.Q[0]   = 0;
    Vec1.Q[0]   = 0;
    Vec2.Q[0]   = 0;
    Vec3.Q[0]   = 0;

    RetVal.S[0] = simd_ex0();
    RetVal.D[0] = simd_ex1(  0 );
    RetVal.B[0] = simd_ex1v( &Vec0 );
    RetVal.H[0] = simd_ex2v( &Vec0, &Vec1 );
    RetVal.W[0] = simd_ex3v( &Vec0, &Vec1, &Vec2 );
    RetVal.X[0] = simd_ex4v( &Vec0, &Vec1, &Vec2, &Vec3 );
    RetVal.W[0] = simd_ex4i( 0, 1, 2, 3 );
    RetVal.X[0] = simd_ex4u( 0, 1, 2, 3 );
    RetVal.Q[0] = simd_exq(  0 );

    printf("\nInput Vector from C++:\n\n");
    for( int i = 0; i < 4; i++ )
    {
        Vec0.S[i] = i + 1;
        printf( "Vec0.W[%d] = %08X, Vec0.S[%d] = %G\n", i, Vec0.W[i], i, Vec0.S[i] );
    }

    RetVal.Q[0] = simd_test( &Vec0, &Vec1, &Vec2, &Vec3 );

    printf("\nOutput Vectors from C++:\n\n");
    for( int i = 0; i < 4; i++ )
    {
        printf( "Vec0.W[%d] = %08X, Vec0.S[%d] = %G\n", i, Vec0.W[i], i, Vec0.S[i] );
    }

    printf("\n");
    for( int i = 0; i < 4; i++ )
    {
        printf( "Vec1.W[%d] = %08X, Vec1.S[%d] = %G\n", i, Vec1.W[i], i, Vec1.S[i] );
    }

    printf("\n");
    for( int i = 0; i < 4; i++ )
    {
        printf( "Vec2.W[%d] = %08X, Vec2.S[%d] = %G\n", i, Vec2.W[i], i, Vec2.S[i] );
    }

    printf("\n");
    for( int i = 0; i < 4; i++ )
    {
        printf( "Vec3.W[%d] = %08X, Vec3.S[%d] = %G\n", i, Vec3.W[i], i, Vec3.S[i] );
    }

    printf( "End of Test\n" );
}
