﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/os/os_SdkThreadApi.h>
#include <nn/time/time_Api.h>
#include <mutex>

struct NroTlsStruct1
{
    int             mInt        = 0x1;
    long long       mLongLong   = 0x10;
    NroTlsStruct1*  mpStruct    = nullptr;
    char            mChar       = '1';
};

extern std::mutex gCoutMutex;

thread_local int    gNroTlsInt1     = 0x11111111;
thread_local float  gNroTlsFloat1   = 1.0f;

void NroPrint1()
{
    thread_local int            tlsInt      = 0x10101010;
    thread_local float          tlsFloat    = 10.0f;
    thread_local NroTlsStruct1* tlsStruct   = nullptr;
    tlsStruct = new NroTlsStruct1();

    gCoutMutex.lock();
    NN_LOG( "NroPrint1()\n" );
    NN_LOG( "NroPrint1: gNroTlsInt1: (0x%p): %x, gNroTlsFloat1: (0x%p): %f\n", &gNroTlsInt1, gNroTlsInt1, &gNroTlsFloat1, gNroTlsFloat1 );
    NN_LOG( "NroPrint1: tlsInt:      (0x%p): %x, tlsFloat:      (0x%p): %f\n", &tlsInt, tlsInt, &tlsFloat, tlsFloat );
    NN_LOG( "NroPrint1: tlsStruct:   (0x%p): {%x, %llx, %p, %c}\n", &tlsStruct, tlsStruct->mInt, tlsStruct->mLongLong, tlsStruct->mpStruct, tlsStruct->mChar );
    NN_LOG( "\n" );
    gCoutMutex.unlock();

    nn::os::SleepThread( nn::TimeSpan::FromSeconds( 1 ) ); // Set breakpoint here.

    delete tlsStruct;
}
