﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/os/os_SdkThreadApi.h>
#include <nn/time/time_Api.h>
#include <mutex>

struct LibTlsStruct2
{
    int             mInt        = 0x2;
    long long       mLongLong   = 0x20;
    LibTlsStruct2*  mpStruct    = nullptr;
    char            mChar       = '2';
};

extern std::mutex gCoutMutex;

thread_local int    gLibTlsInt2     = 0x22222222;
thread_local float  gLibTlsFloat2   = 20.0f;

void LibPrint2()
{
    thread_local int            tlsInt      = 0x20202020;
    thread_local float          tlsFloat    = 200.0f;
    thread_local LibTlsStruct2* tlsStruct   = nullptr;
    tlsStruct = new LibTlsStruct2();

    gCoutMutex.lock();
    NN_LOG( "LibPrint2()\n" );
    NN_LOG( "LibPrint2: gLibTlsInt2:  (0x%p): %x, gLibTlsFloat2: (0x%p): %f\n", &gLibTlsInt2, gLibTlsInt2, &gLibTlsFloat2, gLibTlsFloat2 );
    NN_LOG( "LibPrint2: tlsInt:       (0x%p): %x, tlsFloat:      (0x%p): %f\n", &tlsInt, tlsInt, &tlsFloat, tlsFloat );
    NN_LOG( "LibPrint2: tlsStruct:    (0x%p): {%x, %llx, %p, %c}\n", &tlsStruct, tlsStruct->mInt, tlsStruct->mLongLong, tlsStruct->mpStruct, tlsStruct->mChar );
    NN_LOG( "\n" );
    gCoutMutex.unlock(); // TLSVariablesTestBP02

    nn::os::SleepThread( nn::TimeSpan::FromSeconds( 1 ) );

    delete tlsStruct;
}
