﻿// The purpose of this test is to validate the expression parser
// can correctly locate a variety of class member variables.

#include <cstdint>
#include <stdint.h>
#include <stdio.h>

// A few functions for testing function pointers.
void TheVoidFunction( void )
{
    printf( "TheVoidFunction was called.\n" );
}

int TheIntFunction( int TheInt, int* pTheInt, const int& TheIntRef )
{
    printf( "TheIntFunction was called with %d.\n", TheInt );
    return TheInt;
}

double TheDoubleFunction( double TheDouble, double* pTheDouble, const double& TheDoubleRef )
{
    printf( "TheDoubleFunction was called with %f.\n", TheDouble );
    return TheDouble;
}

// A wrapper to test pointers within classes.
class DataWrapper
{
public:

    // Basic types.
    short           m_Short;
    int             m_Int;
    long long int   m_LLInt;
    float           m_Float;
    double          m_Double;
    long double     m_LDouble;
    char            m_Char;
    wchar_t         m_WChar;

    // Array of basic types.
    short           m_aShort[2];
    int             m_aInt[2];
    long long int   m_aLLInt[2];
    float           m_aFloat[2];
    double          m_aDouble[2];
    long double     m_aLDouble[2];
    char            m_aChar[2];
    wchar_t         m_aWChar[2];

    // Pointers to basic types.
    short*          m_pShort;
    int*            m_pInt;
    long long int*  m_pLLInt;
    float*          m_pFloat;
    double*         m_pDouble;
    long double*    m_pLDouble;
    char*           m_pChar;
    wchar_t*        m_pWChar;

    // Arrays to pointers.
    short*          m_apShort[2];
    int*            m_apInt[2];
    long long int*  m_apLLInt[2];
    float*          m_apFloat[2];
    double*         m_apDouble[2];
    long double*    m_apLDouble[2];
    char*           m_apChar[2];
    wchar_t*        m_apWChar[2];

    // Pointers to arrays.
    short           (*m_paShort)[2];
    int             (*m_paInt)[2];
    long long int   (*m_paLLInt)[2];
    float           (*m_paFloat)[2];
    double          (*m_paDouble)[2];
    long double     (*m_paLDouble)[2];
    char            (*m_paChar)[2];
    wchar_t         (*m_paWChar)[2];

    // Arrays of pointers to pointers.
    short**          m_appShort[2];
    int**            m_appInt[2];
    long long int**  m_appLLInt[2];
    float**          m_appFloat[2];
    double**         m_appDouble[2];
    long double**    m_appLDouble[2];
    char**           m_appChar[2];
    wchar_t**        m_appWChar[2];

    // Pointers to functions.
    void             (*m_pTheVoidFunction)      ( void );
    int              (*m_pTheIntFunction)       ( int, int*, const int& );
    double           (*m_pTheDoubleFunction)    ( double, double*, const double& );

    // Pointers to pointers to functions.
    void             (**m_ppTheVoidFunction)    ( void );
    int              (**m_ppTheIntFunction)     ( int, int*, const int& );
    double           (**m_ppTheDoubleFunction)  ( double, double*, const double& );

    // Various levels of pointers.
    DataWrapper*      m_pDataWrapper;
    DataWrapper**     m_ppDataWrapper;
    DataWrapper***    m_pppDataWrapper;
    DataWrapper****   m_ppppDataWrapper;
    DataWrapper*****  m_pppppDataWrapper;
    DataWrapper****** m_ppppppDataWrapper;
    DataWrapper*      m_apDataWrapper[2];

public:
    DataWrapper( int seed )
    {
        m_Short     = 1*seed;
        m_Int       = 2*seed;
        m_LLInt     = 3*seed;
        m_Float     = 4*seed;
        m_Double    = 5*seed;
        m_LDouble   = 6*seed;
        m_Char      = 'A';
        m_WChar     = L'A';

        m_aShort[0]     = m_Short;
        m_aInt[0]       = m_Int;
        m_aLLInt[0]     = m_LLInt;
        m_aFloat[0]     = m_Float;
        m_aDouble[0]    = m_Double;
        m_aLDouble[0]   = m_LDouble;
        m_aChar[0]      = m_Char;
        m_aWChar[0]     = m_WChar;
        m_aShort[1]     = m_Short+1;
        m_aInt[1]       = m_Int+1;
        m_aLLInt[1]     = m_LLInt+1;
        m_aFloat[1]     = m_Float+1;
        m_aDouble[1]    = m_Double+1;
        m_aLDouble[1]   = m_LDouble+1;
        m_aChar[1]      = m_Char+1;
        m_aWChar[1]     = m_WChar+1;

        m_pShort    = new short(0-m_Short);
        m_pInt      = new int(0-m_Int);
        m_pLLInt    = new long long int(0-m_LLInt);
        m_pFloat    = new float(0-m_Float);
        m_pDouble   = new double(0-m_Double);
        m_pLDouble  = new long double(0-m_LDouble);
        m_pChar     = new char(m_Char+1);
        m_pWChar    = new wchar_t(m_WChar+1);

        m_apShort[0]    = new short(0-m_Short);
        m_apInt[0]      = new int(0-m_Int);
        m_apLLInt[0]    = new long long int(0-m_LLInt);
        m_apFloat[0]    = new float(0-m_Float);
        m_apDouble[0]   = new double(0-m_Double);
        m_apLDouble[0]  = new long double(0-m_LDouble);
        m_apChar[0]     = new char(m_Char+1);
        m_apWChar[0]    = new wchar_t(m_WChar+1);

        m_apShort[1]    = new short(1-m_Short);
        m_apInt[1]      = new int(1-m_Int);
        m_apLLInt[1]    = new long long int(1-m_LLInt);
        m_apFloat[1]    = new float(1-m_Float);
        m_apDouble[1]   = new double(1-m_Double);
        m_apLDouble[1]  = new long double(1-m_LDouble);
        m_apChar[1]     = new char(m_Char+2);
        m_apWChar[1]    = new wchar_t(m_WChar+2);

        m_paShort       = &m_aShort;
        m_paInt         = &m_aInt;
        m_paLLInt       = &m_aLLInt;
        m_paFloat       = &m_aFloat;
        m_paDouble      = &m_aDouble;
        m_paLDouble     = &m_aLDouble;
        m_paChar        = &m_aChar;
        m_paWChar       = &m_aWChar;

        m_appShort[0]    = new short*(m_pShort);
        m_appInt[0]      = new int*(m_pInt);
        m_appLLInt[0]    = new long long int*(m_pLLInt);
        m_appFloat[0]    = new float*(m_pFloat);
        m_appDouble[0]   = new double*(m_pDouble);
        m_appLDouble[0]  = new long double*(m_pLDouble);
        m_appChar[0]     = new char*(m_pChar);
        m_appWChar[0]    = new wchar_t*(m_pWChar);

        m_appShort[1]    = new short*(m_pShort);
        m_appInt[1]      = new int*(m_pInt);
        m_appLLInt[1]    = new long long int*(m_pLLInt);
        m_appFloat[1]    = new float*(m_pFloat);
        m_appDouble[1]   = new double*(m_pDouble);
        m_appLDouble[1]  = new long double*(m_pLDouble);
        m_appChar[1]     = new char*(m_pChar);
        m_appWChar[1]    = new wchar_t*(m_pWChar);

        m_pTheVoidFunction      = TheVoidFunction;
        m_pTheIntFunction       = TheIntFunction;
        m_pTheDoubleFunction    = TheDoubleFunction;

        m_ppTheVoidFunction     = &m_pTheVoidFunction;
        m_ppTheIntFunction      = &m_pTheIntFunction;
        m_ppTheDoubleFunction   = &m_pTheDoubleFunction;

        m_pDataWrapper      = nullptr;
        m_ppDataWrapper     = nullptr;
        m_pppDataWrapper    = nullptr;
        m_ppppDataWrapper   = nullptr;
        m_pppppDataWrapper  = nullptr;
        m_ppppppDataWrapper = nullptr;

        // Pointer math checks. These pointers should match their assigned
        // values in the watch window.
        short*          m_pShortPlus1       = m_pShort+1;
        int*            m_pIntPlus1         = m_pInt+1;
        long long int*  m_pLLIntPlus1       = m_pLLInt+1;
        float*          m_pFloatPlus1       = m_pFloat+1;
        double*         m_pDoublePlus1      = m_pDouble+1;
        long double*    m_pLDoublePlus1     = m_pLDouble+1;
        char*           m_pCharPlus1        = m_pChar+1;
        wchar_t*        m_pWCharPlus1       = m_pWChar+1;
        DataWrapper*    m_pDataWrapperPlus1 = m_pDataWrapper+1;

        // Arrays of pointers.
        short**          m_apShortPlus1         = m_apShort+1;
        int**            m_apIntPlus1           = m_apInt+1;
        long long int**  m_apLLIntPlus1         = m_apLLInt+1;
        float**          m_apFloatPlus1         = m_apFloat+1;
        double**         m_apDoublePlus1        = m_apDouble+1;
        long double**    m_apLDoublePlus1       = m_apLDouble+1;
        char**           m_apCharPlus1          = m_apChar+1;
        wchar_t**        m_apWCharPlus1         = m_apWChar+1;
        DataWrapper**    m_apDataWrapperPlus1   = m_apDataWrapper+1;

        // Pointers to arrays.
        short           (*m_paShortPlus1)[2]    = m_paShort+1;
        int             (*m_paIntPlus1)[2]      = m_paInt+1;
        long long int   (*m_paLLIntPlus1)[2]    = m_paLLInt+1;
        float           (*m_paFloatPlus1)[2]    = m_paFloat+1;
        double          (*m_paDoublePlus1)[2]   = m_paDouble+1;
        long double     (*m_paLDoublePlus1)[2]  = m_paLDouble+1;
        char            (*m_paCharPlus1)[2]     = m_paChar+1;
        wchar_t         (*m_paWCharPlus1)[2]    = m_paWChar+1;

        // Arrays of pointers to pointers.
        short***          m_appShortPlus1       = m_appShort+1;
        int***            m_appIntPlus1         = m_appInt+1;
        long long int***  m_appLLIntPlus1       = m_appLLInt+1;
        float***          m_appFloatPlus1       = m_appFloat+1;
        double***         m_appDoublePlus1      = m_appDouble+1;
        long double***    m_appLDoublePlus1     = m_appLDouble+1;
        char***           m_appCharPlus1        = m_appChar+1;
        wchar_t***        m_appWCharPlus1       = m_appWChar+1;
        DataWrapper***    m_pppDataWrapperPlus1 = m_pppDataWrapper+1;

        // Pointer index checks. These pointers should match their assigned
        // values in the watch window.
        short          m_pShortIndex1       = m_pShort[1];
        int            m_pIntIndex1         = m_pInt[1];
        long long int  m_pLLIntIndex1       = m_pLLInt[1];
        float          m_pFloatIndex1       = m_pFloat[1];
        double         m_pDoubleIndex1      = m_pDouble[1];
        long double    m_pLDoubleIndex1     = m_pLDouble[1];
        char           m_pCharIndex1        = m_pChar[1];
        wchar_t        m_pWCharIndex1       = m_pWChar[1];

        // Arrays of pointers.
        short*          m_apShortIndex1         = m_apShort[1];
        int*            m_apIntIndex1           = m_apInt[1];
        long long int*  m_apLLIntIndex1         = m_apLLInt[1];
        float*          m_apFloatIndex1         = m_apFloat[1];
        double*         m_apDoubleIndex1        = m_apDouble[1];
        long double*    m_apLDoubleIndex1       = m_apLDouble[1];
        char*           m_apCharIndex1          = m_apChar[1];
        wchar_t*        m_apWCharIndex1         = m_apWChar[1];

        // Pointers to arrays.
        short           (*m_paShortIndex1)    = m_paShort[1];
        int             (*m_paIntIndex1)      = m_paInt[1];
        long long int   (*m_paLLIntIndex1)    = m_paLLInt[1];
        float           (*m_paFloatIndex1)    = m_paFloat[1];
        double          (*m_paDoubleIndex1)   = m_paDouble[1];
        long double     (*m_paLDoubleIndex1)  = m_paLDouble[1];
        char            (*m_paCharIndex1)     = m_paChar[1];
        wchar_t         (*m_paWCharIndex1)    = m_paWChar[1];

        // Arrays of pointers to pointers.
        short**          m_appShortIndex1       = m_appShort[1];
        int**            m_appIntIndex1         = m_appInt[1];
        long long int**  m_appLLIntIndex1       = m_appLLInt[1];
        float**          m_appFloatIndex1       = m_appFloat[1];
        double**         m_appDoubleIndex1      = m_appDouble[1];
        long double**    m_appLDoubleIndex1     = m_appLDouble[1];
        char**           m_appCharIndex1        = m_appChar[1];
        wchar_t**        m_appWCharIndex1       = m_appWChar[1];

        int hold = 0; // Place breakpoint here for arithmetic test.
    }
    DataWrapper( ) : DataWrapper( 0 ){};
};

//==============================================================================

extern "C" void nnMain ( void )
{
    DataWrapper DW1(1);
    DataWrapper DW2(2);
    DataWrapper DW3(3);

    short*         pLocalShort      = new short;
    int*           pLocalInt        = new int;
    long long int* pLocalLLInt      = new long long int;
    float*         pLocalFloat      = new float;
    double*        pLocalDouble     = new double;
    long double*   pLocalLDouble    = new long double;
    char*          pLocalChar       = new char;
    wchar_t*       pLocalWChar      = new wchar_t;

    DW1.m_pDataWrapper      = &DW1;
    DW1.m_ppDataWrapper     = &DW1.m_pDataWrapper;
    DW1.m_pppDataWrapper    = &DW1.m_ppDataWrapper;
    DW1.m_ppppDataWrapper   = &DW1.m_pppDataWrapper;
    DW1.m_pppppDataWrapper  = &DW1.m_ppppDataWrapper;
    DW1.m_ppppppDataWrapper = &DW1.m_pppppDataWrapper;
    DW2.m_pDataWrapper      = &DW2;
    DW2.m_ppDataWrapper     = &DW2.m_pDataWrapper;
    DW2.m_pppDataWrapper    = &DW2.m_ppDataWrapper;
    DW2.m_ppppDataWrapper   = &DW2.m_pppDataWrapper;
    DW2.m_pppppDataWrapper  = &DW2.m_ppppDataWrapper;
    DW2.m_ppppppDataWrapper = &DW2.m_pppppDataWrapper;
    DW1.m_apDataWrapper[0]  = &DW2;
    DW1.m_apDataWrapper[1]  = &DW3;

    return; // Place breakpoint here for writing pointers test.
}
