﻿// The purpose of this class is to generate location lists. Generating location
// list requires the build to enable O1 optimizations.

#include <stdio.h>

class OptClass
{
private:
    int             m_Int;
    float           m_Float;
    double          m_Double;
    int             m_SingleBit:1;
    unsigned int    m_USingleBit:1;
    int             m_7Bits:7;
    unsigned int    m_U7Bits:7;
public:
    OptClass()
    {
        m_Int           = 1;
        m_Float         = 1.0f;
        m_Double        = 1.0;
        m_SingleBit     = 1;
        m_USingleBit    = 1;
        m_7Bits         = 1;
        m_U7Bits        = 1;
    }
    void print2( int j, float f, double d )
    { // OptimizedVariablesTestBP01 - Set breakpoint here, with O1 optimization enabled. j, k, f, and d should use location lists and k should be out of range.
        int k = 10;
        printf( "print2\n" );
        printf( "j = %d\n", j );
        k += j;
        printf( "k = %d\n", k );
        printf( "f = %f\n", f );
        printf( "d = %f\n", d );
    }

    void print1( int i )
    {
        int k = 100;
        printf( "print1\n" );
        printf( "i = %d\n", i );
        k += i;
        printf( "k = %d\n", k );
        print2( i, 2.0, 4.0 );
    }
};

extern "C" int nnMain( int argc )
{
    OptClass optClass;
    optClass.print1( 123 );
    return 0;
}
