﻿// The purpose of this test is to validate the expression parser
// can correctly locate a variety of class member variables.

#include <cstdint>
#include <stdint.h>
#include <vector>
#include <map>
#include "..\ExpressionParserVariables\Structures.h"

#define ARRAY_X_SIZE    3
#define ARRAY_XXX_SIZE  3 * 2 * 5

// Anonymous namespace.
namespace
{
    int32_t ns_unknownTest = 32;
    namespace NS_TEST
    {
        int32_t NS_TestValue;
        namespace NS_TEST_C
        {
            int32_t NS_TestCounter;
        }
        const int32_t NS_SecondTestValue = 512;
    }
}

typedef void ( *VOIDFUNC )(int i);
typedef const int** PPInt;

// Globals.
int INT_GLOBAL = 123;
short SHORT_GLOBAL = 456;

// Simple struct.
struct FloatStruct
{
    float x;
};

// Longest possible name for a type, only visible in hover use case.
struct TheReallyLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongNameStruct
{
    long l;
};

// Complex templating test case
template <class A>
class Class1
{
public:
    Class1( ) : m_A(){};
public:
    A m_A;
};

template <class B>
class Class2 : private Class1<int>
{
public:
    Class2( ) : m_B(){};
public:
    B m_B;
};

template <class C>
class Class3 : protected Class2<int>
{
public:
    Class3( ) : m_C(){};
public:
    C m_C;
};

template <class D>
class Class4 : public Class3<int>
{
public:
    Class4( ) : m_D(){};
public:
    D m_D;
};

template <class E, class F>
class Class5 : public Class4<int>
{
public:
    Class5( ) : m_E(), m_F(){};
public:
    E m_E;
    F m_F;
};

// Huge chunk of data.
struct HugeBuffer
{
    int  m_BufferIndex;
    char m_Buffer[1024];
};

// Class that wraps nearly all variables. Set a breakpoint within this class to
// test the parser for a variety of types.
class FloatStructWrapper {
public:
    FloatStructWrapper( ) :
        m_rInt( INT_GLOBAL )
    {
        m_fs.x = 1.0f;
        m_short = SHORT_GLOBAL;
        R0 = 100.0f;
        m_TheReallyLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongMemberStruct.l = 130;
    }
    virtual void incrementNumbers( )
    {
        double R1 = 200.0f; // Same as a register name - local variable should take precedence.
        m_fs.x+=m_short; // ClassLocalsTestBP01
    }
private:
    FloatStruct m_fs;
    int&        m_rInt;
    short       m_short;
    double      R0; // Same as a register name - class member should take precedence.
    TheReallyLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongNameStruct m_TheReallyLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongMemberStruct;
};

// For testing complex classes as a function param.
void DoIncrementNumbers( FloatStructWrapper& fsw )
{
    fsw.incrementNumbers( ); // ClassDrilldownTestBP01
}

class RefClass
{
public:
    int m_Value;
};

class RefContainer
{
public:
    RefContainer( RefClass& x );
private:
    RefClass& m_Ref;
};

RefContainer::RefContainer( RefClass& x ) : m_Ref( x )
{
}

class HugeDataStructure
{
public:
    HugeDataStructure ( ) :
        ra( a ),
        m_fsw( ),
        m_Container(m_Ref)
    {
        ClassA.x     = 5;
        ClassA.y     = 7;
        ClassA.pNext = &ClassB;
        ClassB.x     = 102;
        ClassB.y     = 272;
        ClassB.pNext = &ClassA;
        pClassA      = ClassB.pNext;

        // Pointer to int.
        vpx  = &(ArrayXXX[1][1][1]);
        px   = (int*)vpx;
        ppx  = &px;
        vppx = (void**)ppx;

        ppIntX = ppx;
        vppix  = (void**)ppIntX;
        pfb    = &b;
        ra     = a;

        // Array of struct test.
        TCArray[0].x = 198;
        TCArray[0].y = 199;
        TCArray[0].pNext = &TCArray[1];

        TCArray[1].x = 298;
        TCArray[1].y = 299;
        TCArray[1].pNext = &TCArray[0];

        TCArrayP[0] = &TCArray[0];
        TCArrayP[1] = &TCArray[1];

        var = 42;
        pVar = &var;
        ppVar = &pVar;
        pppVar = &ppVar;
        ppppVar = &pppVar;
        pppppVar = &ppppVar;

        list[0] = 99;
        list[1] = 88;
        list[2] = 77;
        list[3] = 66;
        list[4] = 55;
        list[5] = 44;
        list[6] = 33;
        list[7] = 22;

        list2[0] = 9;
        list2[1] = 8;
        list2[2] = 7;
        list2[3] = 6;
        list2[4] = 5;
        list2[5] = 4;
        list2[6] = 3;
        list2[7] = 2;

        pList = &list;
        ppList = &pList;
        pppList = &ppList;
        ppppList = &pppList;
        pppppList = &ppppList;

        for (int i = 0; i < 8; ++i)
        {
            pList2[i] = &list[i];
            ppList2[i] = &pList2[i];
            pppList2[i] = &ppList2[i];
            ppppList2[i] = &pppList2[i];
            pppppList2[i] = &ppppList2[i];
        }

        A = 34; // 0x22 hex
        B = 51; // 0x33 hex
        C = 68; // 0x44 hex

        simple_array[0] = A;
        simple_array[1] = B;
        simple_array[2] = C;

        pPtrToArray = &simple_array;

        simple_ptr_array[0] = &A;
        simple_ptr_array[1] = &B;
        simple_ptr_array[2] = &C;

        pPtrToPtrArray = &simple_ptr_array;

        double_ptr_array[0] = &simple_ptr_array[0];
        double_ptr_array[1] = &simple_ptr_array[1];
        double_ptr_array[2] = &simple_ptr_array[2];

        pPtrToDoublePtrArray = &double_ptr_array;

        TestField.A = 3;
        TestField.B = 7;
        TestField.C = 2;

        pTestField = &TestField;

        TestFieldOdd.A = 4095;  // -1
        TestFieldOdd.B = 4095;  // 4095
        TestFieldOdd.C = -4095; // 1
        TestFieldOdd.D = 199;   // 7
        TestFieldOdd.E = 409;   // 9 '\t'

        pFoo = 0;

        for (s32 i = 0; i < 5; i++)
        {
            cTable[i] = 5 + i;
            vTable[i].x = 1 + i * 3;
            vTable[i].y = 50 + i * 7;
            vTable[i].z = 1000 + i * 100;
        }

        for (s32 i = 0; i < 4; i++)
        {
            int i0 = 0;
            int i1 = i + 1;
            int i2 = (i + 1) % 4 + 1;

            Verts[i * 3 + 0].Position = vTable[i0];
            Verts[i * 3 + 0].Color = cTable[i0];
            Verts[i * 3 + 1].Position = vTable[i2];
            Verts[i * 3 + 1].Color = cTable[i2];
            Verts[i * 3 + 2].Position = vTable[i1];
            Verts[i * 3 + 2].Color = cTable[i1];
        }

        ColorTest.A = 71;
        ColorTest.B = 28;
        ColorTest.G = 55;
        ColorTest.R = 128;

        bTest = true;

        if (bTest)
        {
            for (int iCell = 0; iCell < 10; iCell++)
            {
                cell_ptr[iCell] = &cell_map[10 - iCell - 1];

                cell_map[iCell].m_i = 0;
                cell_map[iCell].m_j = iCell;

                for (int iBase = 0; iBase < 7; iBase++)
                {
                    cell_map[iCell].m_Base[iBase].x = iCell * 10;
                    cell_map[iCell].m_Base[iBase].y = iBase * 10;
                    cell_map[iCell].m_Base[iBase].z = 2;
                }
            }
        }
        pCellPtr = &cell_ptr[0];

        ObjMgr1.Init ( 3 );
        ObjMgr2.Init ( 7 );
        ObjMgr3.Init ( 9 );

        ObjMgr2.AddToTypes ( 7 );
        ObjMgr2.SetId ( 0xbeefdead );

        ::ns_unknownTest += ::ns_unknownTest;
        NS_TEST::NS_TestValue = ::ns_unknownTest;
        NS_TEST::NS_TEST_C::NS_TestCounter = NS_TEST::NS_SecondTestValue * 2;
        for (int32_t X = 0; X < NS_TEST::NS_TEST_C::NS_TestCounter; X++)
        {
            NS_TEST::NS_TestValue += X;
            if (NS_TEST::NS_TestValue > NS_TEST::NS_SecondTestValue)
                break;
        }

        unionTest1.control = 170;
        unionTest1.int0 = 5;

        unionTest2.control = 170;
        unionTest2.internal.float0 = 9.0f;

        anonymousTest.m_ValueNU = 0xff;
        anonymousTest.m_DataU = 0xcc;
        anonymousTest.m_DataI = 0xaa;
        anonymousTest.m_DataSA = 0xee;
        anonymousTest.m_DataSB = 0xbb;

        anonymousTest.m_StructU = 0xcc;
        anonymousTest.m_StructI = 0xaa;
        anonymousTest.m_StructSA = 0xee;
        anonymousTest.m_StructSB = 0xbb;

        EnumTest1 = (LocalTestEnum)3;
        EnumTest2 = LTE_TEST4;

        pNullCell = 0;
        pCellPtr2 = &pNullCell;
        pCellPtr3 = &pCellPtr2;

        container.m_pCells = &pNullCell;

        DoIncrementNumbers( m_fsw );

        //Overide the global and verify the local takes precendence,
        //Also verify the global can be found using "::INT_GLOBAL"
        int INT_GLOBAL = 123456789;

        ArrayOfDoubles[0] = 1.0f;
        ArrayOfDoubles[1] = 2.0f;
        ArrayOfDoubles[2] = 3.0f;

        VectorOfInts.push_back( 2 );
        VectorOfInts.push_back( 4 );
        VectorOfInts.push_back( 8 );

        MapOfIntToFloats.insert( std::pair<int, float>( 1, 1.0 ) );
        MapOfIntToFloats.insert( std::pair<int, float>( 2, 2.0 ) );
        MapOfIntToFloats.insert( std::pair<int, float>( 3, 3.0 ) );

        ArrayOfBuffers[0].m_BufferIndex = 0;
        ArrayOfBuffers[1].m_BufferIndex = 1;

        m_Ref.m_Value = 100;

        m_BitFieldA = 0x1;
        m_BitFieldB = 0x0;
        m_BitFieldC = 0x1;
        m_BitFieldD = 0x0;

        int Hold = a+b+c+d+e+ArrayX[0]+ArrayXXX[0][0][0]; // ClassMembersTestBP01 // WriteClassMembersTestBP01 // ClassMembersAddressesTestBP01 // LargeArrayTestBP01

        delete[] ArrayOfDoubles;
    }
private:
    static s32 a;
    static f32 b;
    static s64 c;
    static f64 d;
    static u64 e;

    static s32 ArrayX[3];
    static s32 ArrayXXX[3][2][5];

    static test_class ClassA;
    static test_class ClassB;
    test_class* pClassA;

    const void* vpx;
    const int*  px;
    const int** ppx;
    void**      vppx;

    char LargeBufferToCreateLargeMemberOffsets[0xFFFF] = { 0 };

    PPInt  ppIntX;
    void** vppix;
    f32*   pfb;
    int&   ra;

    test_class  TCArray[2];
    test_class* TCArrayP[2];

    int      var;
    int*     pVar;
    int**    ppVar;
    int***   pppVar;
    int****  ppppVar;
    int***** pppppVar;

    int list[8];
    int list2[8];
    int ( *pList )[8];
    int ( **ppList )[8];
    int ( ***pppList )[8];
    int ( ****ppppList )[8];
    int ( *****pppppList )[8];

    int*     pList2[8];
    int**    ppList2[8];
    int***   pppList2[8];
    int****  ppppList2[8];
    int***** pppppList2[8];

    short A;
    short B;
    short C;

    short   simple_array[3];
    short   ( *pPtrToArray )[3];
    short*  simple_ptr_array[3];
    short*  (*pPtrToPtrArray)[3];
    short** double_ptr_array[3];
    short** (*pPtrToDoublePtrArray)[3];

    BitField TestField;
    BitField* pTestField;

    BitfieldX TestFieldOdd;
    test_class* pFoo;
    vector3 vTable[5];
    unsigned long cTable[5];

    vertex_pc Verts[4 * 3];
    color ColorTest;
    cell* cell_ptr[10];
    cell  cell_map[10];

    bool bTest;
    cell** pCellPtr;

    obj_mgr ObjMgr1;
    obj_mgr ObjMgr2;
    obj_mgr ObjMgr3;

    UnionTest_Anonymous unionTest1;
    UnionTest_Named unionTest2;
    ComplexAnonymous anonymousTest;

    LocalTestEnum EnumTest1;
    LocalTestEnum EnumTest2;

    cell* pNullCell;
    cell** pCellPtr2;
    cell*** pCellPtr3;

    CellContainer container;
    FloatStructWrapper m_fsw;

    double* ArrayOfDoubles = new double[3];

    std::vector<int>     VectorOfInts;
    std::map<int, float> MapOfIntToFloats;

    Class4<int>                        MyTemplateClass4;
    Class5<Class1<int>, Class2<float>> MyTemplateClass5;

    HugeBuffer ArrayOfBuffers[2];

    RefClass     m_Ref;
    RefContainer m_Container;

    unsigned int m_BitFieldA : 1;
    unsigned int m_BitFieldB : 1;
    unsigned int m_BitFieldC : 1;
    unsigned int m_BitFieldD : 1;
};
s32 HugeDataStructure::a = 3;
f32 HugeDataStructure::b = 7.21f;
s64 HugeDataStructure::c = -1;
f64 HugeDataStructure::d = 14.4f;
u64 HugeDataStructure::e = 92;
s32 HugeDataStructure::ArrayX[3] = { 71, 72, 73 };
s32 HugeDataStructure::ArrayXXX[3][2][5] = { 11, 12, 13, 14, 15, 21, 22, 23, 24, 25, 31, 32, 33, 34, 35, 41, 42, 43, 44, 45, 51, 52, 53, 54, 55, 61, 62, 63, 64, 65 };
test_class HugeDataStructure::ClassA;
test_class HugeDataStructure::ClassB;

//==============================================================================

#ifndef __NX__
int main ( int argc, char** argv )
#else
extern "C" void nnMain ( void )
#endif
{
    HugeDataStructure hds;
#ifndef __NX__
    return 0;
#endif
}
