﻿//==============================================================================
//
//  stdafx.h for Gamma
//
//  Include file for standard system include files, or project-specific include
//  files that are used frequently but change infrequently.
//
//==============================================================================

#ifndef STDAFX_H
#define STDAFX_H

#include <cstdlib>
#ifdef NN_NINTENDO_SDK
#include <cstdarg>
#include <nn/os.h>
#include <nn/os/os_Base.h>
#include <nn\nn_Log.h>
#define REPORT( ... ) NN_LOG(__VA_ARGS__)
#define SLEEP( X ) nn::os::SleepThread( nn::TimeSpan::FromSeconds( (X) ))
#else
#include <stdio.h>
#include <stdlib.h>
#define Sleep(X) (X)
#define REPORT( ... ) printf( __VA_ARGS__ )
#define SLEEP( X ) Sleep( (X) * 1000 )
#endif

#endif
