﻿function IsValidErrorCode(categoryString, numberString)
{
    if (categoryString.length == 4 && numberString.length == 4)
    {
        var categoryNumber = parseInt(categoryString, 10);
        var numberNumber = parseInt(numberString, 10);
        if( categoryNumber >= 2000 && categoryNumber <= 2999 && numberNumber >= 0 && numberNumber <= 8192 /* = 0x1FFF*/ )
        {
            return true;
        }
        return false;
    }
    return false;
}

function GetResultInnerValueFromErrorCode(categoryString, numberString)
{
    var module = parseInt(categoryString, 10) - 2000;
    var description = parseInt(numberString, 10);
    return (description << 9) | (module);
}

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

var previousErrorCodeCategory;
var previousErrorCodeNumber;

function OnErrorCodeTextChanged_Result()
{
    var categoryString = document.getElementById("errorCodeCategory").value;
    var numberString = document.getElementById("errorCodeNumber").value;
    if(categoryString == previousErrorCodeCategory && numberString == previousErrorCodeNumber)
    {
        return;
    }
    previousErrorCodeCategory = categoryString;
    previousErrorCodeNumber = numberString;

    if( IsValidErrorCode(categoryString, numberString) )
    {
        var value = GetResultInnerValueFromErrorCode(categoryString, numberString);
        document.getElementById("errorCodeValidity").innerHTML = "";
        SetSearchResult(value);
    }
    else
    {
        document.getElementById("errorCodeValidity").innerHTML = "（不正なエラーコード）";
        ClearSearchResult();
    }
}

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

function OnLoad()
{
    RegisterEventHandler(document.getElementById("errorCodeCategory"), "mouseup", this, OnErrorCodeTextChanged_Result, false);
    RegisterEventHandler(document.getElementById("errorCodeCategory"), "keyup", this, OnErrorCodeTextChanged_Result, false);
    RegisterEventHandler(document.getElementById("errorCodeCategory"), "change", this, OnErrorCodeTextChanged_Result, false);

    RegisterEventHandler(document.getElementById("errorCodeNumber"), "mouseup", this, OnErrorCodeTextChanged_Result, false);
    RegisterEventHandler(document.getElementById("errorCodeNumber"), "keyup", this, OnErrorCodeTextChanged_Result, false);
    RegisterEventHandler(document.getElementById("errorCodeNumber"), "change", this, OnErrorCodeTextChanged_Result, false);

    document.getElementById("errorCodeCategory").focus();
    OnErrorCodeTextChanged_Result();
}

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

window.onload = OnLoad;
