/*--------------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo. All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

function ConstructSetting()
{
    this.wizardName = 'NintendoSdkApplicationCustomWizard';
    this.ConfigOptionExecutionKeyName = ['copyAndAddPropertyToSheet', 'addPropertyToProject', 'addSettingProperty'];
}

function Setting() {}
Setting.prototype.sdkRootPath = '';
Setting.prototype.displayPlatformFirst = false;
Setting.prototype.platformNames = [];
Setting.prototype.displayPlatformNames = [];
Setting.prototype.setEnvNames = [];
Setting.prototype.selectPlatforms = [];
Setting.prototype.platformNum = 0;
Setting.prototype.selectedPlatformConfigs = null;
Setting.prototype.selectedPlatformConfigsEnable = [];
Setting.prototype.selectedPlatformConfigsSubEnable = [];
Setting.prototype.executeConfigs = [];

function SettingAccessor() {}

SettingAccessor.updatePlatform = function(setting, nameList)
{
    var lst = [];
    var sellst = [];
    for(var i=0; i<nameList.length; i++)
    {
        lst.push(nameList[i]);
        sellst.push(false);
    }
    setting.platformNames = lst;
    setting.selectPlatforms = sellst;
    setting.platformNum = nameList.length;
    return true;
}

SettingAccessor.updateDisplayPlatform = function(setting, displayNameList)
{
    var lst = [];
    for(var i=0; i<displayNameList.length; i++)
    {
        lst.push(displayNameList[i]);
    }
    setting.displayPlatformNames = lst;
    return true;
}

SettingAccessor.updateEnvName = function(setting, envNameList)
{
    var lst = [];
    for(var i=0; i<envNameList.length; i++)
    {
        lst.push(envNameList[i]);
    }
    setting.setEnvNames = lst;
    return true;
}

SettingAccessor.updatePlatfromSelection = function(setting, index, selection)
{
    if(setting.platformNum < index)
    {
        return false;
    }

    setting.selectPlatforms[index] = selection;
    setting.selectedPlatformConfigsEnable.length = 0;
    return true;
}

SettingAccessor.updateSdkRootPath = function(setting, path)
{
    // pXXVׂȂ̂`FbN
    if(setting.sdkRootPath == path)
    {
        return false;
    }
    setting.sdkRootPath = path;
    CheckAndSetPlatformSettings(setting, path);
    setting.selectedPlatformConfigsEnable.length = 0;
    return true;
}

SettingAccessor.loadPlatformConfigs = function(setting)
{
    var selectPlatformIndex = -1;
    for(var i=0; i<setting.platformNum; i++)
    {
        if(setting.selectPlatforms[i] == true)
        {
            selectPlatformIndex = i;
            break;
        }
    }
    if(selectPlatformIndex == -1)
    {
        setting.selectedPlatformConfigs = null;
        setting.selectedPlatformConfigsEnable.length = 0;
        return;
    }
    setting.selectedPlatformConfigs = new ConfigOptions(setting.sdkRootPath, setting.platformNames[selectPlatformIndex]);
    setting.selectedPlatformConfigs.CheckConfigs();

    if(setting.selectedPlatformConfigsEnable.length == 0)
    {
        for(var i=0; i<setting.selectedPlatformConfigs.configs.length; i++)
        {
            setting.selectedPlatformConfigsEnable[i] = false;
            setting.selectedPlatformConfigsSubEnable[i] = [];
            for(var j=0; j<setting.selectedPlatformConfigs.GetConfigSubOptionNum(i) ; j++)
            {
              setting.selectedPlatformConfigsSubEnable[i][j] = false;
            }
        }
    }
}

SettingAccessor.selectPlatformConfigs = function(setting, selectList)
{
}

SettingAccessor.setExecutePlatformConfigs = function(setting)
{
    if(setting.selectedPlatformConfigsEnable.length <= 0)
    {
        setting.executeConfigs.length = 0;
        return;
    }

    var selectPlatformIndex = -1;
    for(var i=0; i<setting.platformNum; i++)
    {
        if(setting.selectPlatforms[i] == true)
        {
            selectPlatformIndex = i;
            break;
        }
    }

    setting.executeConfigs.length = 0;

    var platformConfigOptions = new ConfigOptions(setting.sdkRootPath, setting.platformNames[selectPlatformIndex]);
    platformConfigOptions.CheckConfigs();
    for(var i=0; i<setting.selectedPlatformConfigsEnable.length; i++)
    {
        if(setting.selectedPlatformConfigsEnable[i] == true)
        {
            // TODO: "copyAndAddPropertyToProject"  ConstructSetting.ConfigOptionExecutionKeyName ɒu
            var value = platformConfigOptions.GetValueFromConfigKey(i, "copyAndAddPropertyToProject");
            if(value != null)
            {
                setting.executeConfigs[setting.executeConfigs.length] = {"copyAndAddPropertyToProject": value};
            }

            for(var j=0; j<setting.selectedPlatformConfigsSubEnable[i].length; j++)
            {
                if(setting.selectedPlatformConfigsEnable[i][j] == true)
                {
                    var value = platformConfigOptions.GetSubOptionValueFromConfigKey(i, j, "copyAndAddPropertyToProject");
                    if(value != null)
                    {
                        setting.executeConfigs[setting.executeConfigs.length] = {"copyAndAddPropertyToProject": value};
                    }
                }
            }
        }
    }
}

function WizardPage() {}
WizardPage.prototype.initialized = false;

function WizardPageAccessor() {}

function ConfigOptions(sdkRootPath, platformName)
{
    this.rootPath = sdkRootPath;
    this.platformName = platformName;
    this.configs = ReadConfigs(sdkRootPath, platformName);
    // CheckConfigs();
}

ConfigOptions.prototype.ReadConfigs = function ReadConfigs(sdkRootPath, platformName)
{
    var fso = new ActiveXObject('Scripting.FileSystemObject');
    var wizardPlatformDir = sdkRootPath + '\\Build\\Vc\\CustomWizard\\Platform\\' + platformName + '\\config';
    if(!fso.FolderExists(wizardPlatformDir))
    {
        return [];
    }
    var configOption = null;
    var oFolder = fso.GetFolder(wizardPlatformDir);
    var oEnum = new Enumerator(oFolder.SubFolders);
    var configArray = [];
    for(; !oEnum.atEnd(); oEnum.moveNext())
    {
        var oEnum2 = new Enumerator(oEnum.item().Files);
        for(; !oEnum2.atEnd(); oEnum2.moveNext())
        {
            if(fso.GetExtensionName(oEnum2.item()) == 'json')
            {
                var config = ReadConfigFile(oEnum2.item().Path);
                configArray.push(config);
            }
        }
    }
    return configArray;
}

ConfigOptions.prototype.CheckConfigs = function CheckConfigs()
{
    var deletePos = [];
    if(this.configs == null)
    {
        return;
    }

    var fso = new ActiveXObject('Scripting.FileSystemObject');

    for(var i=0; i<this.configs.length; i++)
    {
        // Version check.
        var checkvar = this.configs[i].configVersion;
        if(checkvar == undefined || checkvar != 1)
        {
            deletePos.push(i);
        }
        // File exist check.
        if("enableIfFileExists" in this.configs[i])
        {
            var checkFilePath = this.rootPath + "\\" + this.GetValueFromConfigKey(i, "enableIfFileExists");
            if(!fso.FileExists(checkFilePath))
            {
                deletePos.push(i);
            }
        }
    }
    for(var i=deletePos.length-1; i>=0; i--)
    {
        this.configs.splice(deletePos[i], 1);
    }
    fso = null;
}

ConfigOptions.prototype.GetConfigName = function GetConfigName(index)
{
    return this.GetValueFromConfigKey(index, "name");
}

ConfigOptions.prototype.GetValueFromConfigKey = function GetValueFromConfigKey(index, configkey)
{
    var localeName = GetLocaleName();
    var value = this.configs[index][configkey];
    if(value == undefined)
    {
        return null;
    }

    if(this.configs[index][configkey][localeName] != undefined)
    {
        return this.configs[index][configkey][localeName];
    }
    else if(this.configs[index][configkey]["default"] != undefined)
    {
        return this.configs[index][configkey]["default"];
    }
    return null;
}

ConfigOptions.prototype.GetConfigSubOptionNum = function GetConfigSubOptionNum(index)
{
    if(this.configs[index]["SubOption"] == undefined)
    {
        return 0;
    }
    return this.configs[index]["SubOption"].length;
}

ConfigOptions.prototype.GetConfigSubOptionName = function GetConfigSubOptionName(index, subIndex)
{
    
    return this.GetSubOptionValueFromConfigKey(index, subIndex, "name");
}

ConfigOptions.prototype.GetSubOptionValueFromConfigKey = function GetSubOptionValueFromConfigKey(index, subIndex, configkey)
{
    var localeName = GetLocaleName();
    if(this.configs[index]["SubOption"] == undefined)
    {
        return null;
    }
    if(subIndex >= this.configs[index]["SubOption"].length)
    {
        return null;
    }

    if(this.configs[index]["SubOption"][subIndex][configkey][localeName] != undefined)
    {
        return this.configs[index]["SubOption"][subIndex][configkey][localeName];
    }
    else if(this.configs[index]["SubOption"][subIndex][configkey]["default"] != undefined)
    {
        return this.configs[index]["SubOption"][subIndex][configkey]["default"];
    }
    return null;
}


function Sleep(time)
{
    var d1 = new Date().getTime();
    var d2 = new Date().getTime();
    while (d2 < d1 + time) {
        d2 = new Date().getTime();
    }
}

function GetEnvironmentValue(strWithEnvValue)
{
    wsh = new ActiveXObject("WScript.Shell");
    return wsh.ExpandEnvironmentStrings(strWithEnvValue);
}

function SetEnvironmentValue(strEnvName, strEnvValue)
{
    var wsh = new ActiveXObject("WScript.Shell");
    var env = wsh.Environment('USER');
    env.item(strEnvName) = strEnvValue;
}

function ComparePathString(strPath1, strPath2)
{
    var strBasePath1, strBasePath2;
    if(strPath1.lastIndexOf("\\") != strPath1.length - 1)
    {
        strBasePath1 = strPath1;
    }
    else
    {
        strBasePath1 = strPath1.substr(0 , strPath1.length-1);
    }
    if(strPath2.lastIndexOf("\\") != strPath2.length - 1)
    {
        strBasePath2 = strPath2;
    }
    else
    {
        strBasePath2 = strPath2.substr(0 , strPath2.length-1);
    }
    if( strBasePath1 == strBasePath2 )
    {
        return true;
    }
    return false;
}

function CheckEnvironmentValue(strEnvName, strEnvValue)
{
    wsh = new ActiveXObject("WScript.Shell");
    var env = wsh.Environment('USER');
    var strRealEnvValue = env.item(strEnvName);
    return ComparePathString(strEnvValue, strRealEnvValue);
}

function GetPlatformNames(strSdkRootDir, strPlatformNames, strWizardName) {
    var strPlatformDirectory = strSdkRootDir + "\\Build\\Vc\\CustomWizard\\Platform\\";
    // PlatformfBNgȂꍇ-1Ԃ
    var fso = new ActiveXObject('Scripting.FileSystemObject');
    if (!fso.FolderExists(strPlatformDirectory)) {
        return -1;
    }

    // Platform fBNgȉ̃fBNgT
    var size = 0;
    var folder = fso.GetFolder(strPlatformDirectory);
    var em = new Enumerator(folder.SubFolders);
    for (em.moveFirst() ; !em.atEnd() ; em.moveNext()) {
        // TfBNĝ "Base" ȊÔ̂zɊi[
        if (em.item().Name == "Base") {
            continue;
        }
        var strCheckFileName = strPlatformDirectory + em.item().Name + "\\" + "PlatformName.txt";
        if (!fso.FileExists(strCheckFileName)) {
            continue;
        }
        size = strPlatformNames.push(em.item().Name);
    }

    fso = null;

    return size;
}

function GetLocaleDirectoryName()
{
    // MEMO: P[ǉꍇ͂̊֐C
    var localeName = navigator.userLanguage;
    var returnName = "";
    switch (localeName) {
        case "en-US":
            returnName = "1033\\";
            break;
    }
    return returnName;
}

function GetLocaleName()
{
    return navigator.userLanguage;
}

function GetPlatformDisplayNames(strSdkRootDir, strPlatformNames, strPlatformDisplayNames)
{
    var fso = new ActiveXObject('Scripting.FileSystemObject');
    var localeDirName = GetLocaleDirectoryName();
    for(var i=0; i < strPlatformNames.length; i++)
    {
        var strFilePath = strSdkRootDir + "\\Build\\Vc\\CustomWizard\\Platform\\" + strPlatformNames[i] + "\\" + localeDirName + "PlatformName.txt";
        if (!fso.FileExists(strFilePath))
        {
            strPlatformDisplayNames[i] = strPlatformNames[i];
            continue;
        }
        var objFile = fso.OpenTextFile(strFilePath);
        var strTest = objFile.ReadLine();
        strPlatformDisplayNames[i] = strTest.replace(/(^\s+)|(\s+$)/g, "");
        objFile.Close();
        objFile = null;
    }
    fso = null;
}

function GetPlatformEnvironmentValue(strSdkRootDir, strPlatformName)
{
    var fso = new ActiveXObject('Scripting.FileSystemObject');
    var envName = '';
    var strFilePath = strSdkRootDir + "\\Build\\Vc\\CustomWizard\\Platform\\" + strPlatformName + "\\SetEnvRoot.txt";
    if (!fso.FileExists(strFilePath))
    {
        return envName;
        fso = null;
    }
    var objFile = fso.OpenTextFile(strFilePath);
    var strTest = objFile.ReadLine();
    envName = strTest.replace(/(^\s+)|(\s+$)/g, "");
    objFile.Close();
    objFile = null;
    fso = null;
    return envName;
}

function CheckAndSetPlatformSettings(setting, sdkPathString)
{
    var platformName = [];
    var constSetting = window.external.FindSymbol('ConstructSetting');
    var wizardName = constSetting.wizardName;
    var sdkPath = GetEnvironmentValue(sdkPathString);

    if (GetPlatformNames(sdkPath, platformName, wizardName) <= 0) {
        return false;
    }
    var platformDisplayName = [];
    var displayIndex = 0;
    GetPlatformDisplayNames(sdkPath, platformName, platformDisplayName);

    var setEnvNames = [];
    for (var i = 0; i < platformName.length; i++) {
        setEnvNames.push(GetPlatformEnvironmentValue(sdkPath, platformName[i]));
    }

    for (var i = 0; i < platformName.length; i++) {
        SettingAccessor.updatePlatform(setting, platformName);
        SettingAccessor.updateDisplayPlatform(setting, platformDisplayName);
        SettingAccessor.updateEnvName(setting, setEnvNames);
    }

    if(platformName.length == 1)
    {
        SettingAccessor.updatePlatfromSelection(setting, 0, true);
    }

    return true;
}

function ClearPlatformSettings(setting)
{
    setting.platformNum = 0;
}

function CheckSdkRootDir(sdkRootPath)
{
    var path = GetEnvironmentValue(sdkRootPath);
    var fso = new ActiveXObject('Scripting.FileSystemObject');
    if (!fso.FolderExists(path + "\\Build\\Vc\\CustomWizard\\Platform")) {
        return false;
    }
    return true;
}

function GetSdkRootListFromPackage()
{
    var ret = [];
    var path = Mugen.getInstallationPath();
    if(path == null)
    {
        return ret;
    }
    var envs = Mugen.getEnvironments(path);

    for(var i = 0; i < envs.length; ++i) {
        ret.push(envs[i].path);
    }

    return ret;
}

function ExecuteExternalCommand(path, arguments, stdOutput, stdErrOutput)
{
    var objFs;
    var objShell;

    var strPathStdIN, strPathStdOUT, strPathStdERR;
    var fileStdIN,    fileStdOUT,    fileStdERR;

    var TmpPath
    var strCommandArray
    var strArgument


    objFs = new ActiveXObject("Scripting.FileSystemObject");

    if(!objFs.FileExists(path))
    {
        return 1;
    }

    // Open temporary file for command's standard in/out/error
    TmpPath=objFs.GetSpecialFolder(2).Path;
    // strPathStdIN=objFs.BuildPath(TmpPath,objFs.GetTempName());
    strPathStdOUT=objFs.BuildPath(TmpPath,objFs.GetTempName());
    strPathStdERR=objFs.BuildPath(TmpPath,objFs.GetTempName());

    // fileStdIN=objFs.CreateTextFile(strPathStdIN);
    // fileStdIN.Close();

    // Execute command
    objShell=new ActiveXObject("WScript.Shell");

    // var returnCode = objShell.Run("CMD.EXE /S /C \"\"" + path + "\" " + arguments + " <\"" + strPathStdIN + "\" 1>\"" + strPathStdOUT + "\" 2>\"" + strPathStdERR + "\"\"", 0, true);
    var returnCode = objShell.Run("CMD.EXE /S /C \"\"" + path + "\" " + arguments + " 1>\"" + strPathStdOUT + "\" 2>\"" + strPathStdERR + "\"\"", 0, true);

    // Open temporary files for command's standard out/err
    while(!objFs.FileExists(strPathStdOUT))
    {
        Sleep(1000);
    }
    fileStdOUT=objFs.OpenTextFile(strPathStdOUT, 1);

    while(!objFs.FileExists(strPathStdERR))
    {
        Sleep(1000);
    }
    fileStdERR=objFs.OpenTextFile(strPathStdERR, 1);

    // Read command's standard out/error
    if(!fileStdOUT.AtEndOfStream)
    {
        stdOutput.value = fileStdOUT.ReadAll();
    }
    else
    {
        stdOutput.value = "";
    }
    if(!fileStdERR.AtEndOfStream)
    {
        stdErrOutput.value = fileStdERR.ReadAll();
    }
    else
    {
        stdErrOutput.value = "";
    }

    // Close and delete temporary files
    fileStdOUT.Close();
    fileStdERR.Close();
    // objFs.DeleteFile(strPathStdIN);
    if(objFs.FileExists(strPathStdOUT))
    {
        objFs.DeleteFile(strPathStdOUT);
    }
    if(objFs.FileExists(strPathStdERR))
    {
        objFs.DeleteFile(strPathStdERR);
    }
    // if(objFs.FileExists(strPathStdIN))
    // {
    //     objFs.DeleteFile(strPathStdIN);
    // }

    return returnCode;
}

function CreateDocumentElement(tagName, isEndTag, parameters)
{
  var tagString = '';
  tagString = '<' + tagName + ' ';
  for(var i=0; i<parameters.length; i++)
  {
    tagString += parameters[i].name + "='" + parameters[i].value + "' ";
  }
  tagString += isEndTag ? '>' : '/>';
  return document.createElement(tagString);
}


function ReadConfigFile(configFilePath)
{
    var ret = null;
    var fso = new ActiveXObject('Scripting.FileSystemObject');
    if (!fso.FileExists(configFilePath))
    {
        fso = null;
        return ret;
    }
    var objFile = fso.OpenTextFile(configFilePath);
    var strText = objFile.ReadAll();
    objFile.Close();
    objFile = null;
    ret = eval("(" + strText + ")");
    fso = null;
    return ret;
}

function ReadSimpleConfigFile(path)
{
    var configLines = [];
    var fso = new ActiveXObject('Scripting.FileSystemObject');
    if (!fso.FileExists(path)) {
        return configLines;
    }
    var objFile = fso.OpenTextFile(path);
    while(objFile.AtEndOfLine == false)
    {
        var strTest = objFile.ReadLine();
        strTest = strTest.replace(/(^\s+)|(\s+$)/g, "");
        if(strTest.length > 0)
        {
            configLines.push(strTest);
        }
    }
    return configLines;
}

