:: ---------------------------------------------------------------------------
:: Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.
::
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.
:: ---------------------------------------------------------------------------

@echo off

:: ---------------------------------------------------------------------------
::
:: Setup git environments.
::
:: ---------------------------------------------------------------------------

set REPOSITORY_ROOT=%~dp0

:: ---------------------------------------------------------------------------
:: Check git command and setup PATH.
:: ---------------------------------------------------------------------------
call "Integrate\Scripts\Modules\Get-GitPath.bat"
if not defined SIGLO_GIT_PATH (
    echo ERROR: Could not found git command. Please install Git for Windows. 1>&2
    goto error
)

echo Found Git installation: %SIGLO_GIT_PATH%
set PATH=%SIGLO_GIT_PATH%cmd;%PATH%

git --version|findstr windows > nul
if %errorlevel% == 0 (
    goto pass_gitcheck
)

git --version|findstr msysgit > nul
if %errorlevel% == 0 (
    echo WARNING: msysgit is obsolete now. Update it to Git for Windows 2.x.
)

:pass_gitcheck

:: ---------------------------------------------------------------------------
:: Set core.autocrlf=false.
:: ---------------------------------------------------------------------------
echo Set core.autocrlf=false.
git config core.autocrlf false

:: ---------------------------------------------------------------------------
:: Setup GitExternalStorage.
:: ---------------------------------------------------------------------------
call "%REPOSITORY_ROOT%Integrate\Repository\Tools\GitExternalStorage\setup.cmd"

:: ---------------------------------------------------------------------------
:: Setup GitExternalRepository.
:: ---------------------------------------------------------------------------
call "%REPOSITORY_ROOT%Integrate\Repository\Tools\GitExternalRepository\setup.cmd"

:: ---------------------------------------------------------------------------
:: Setup GitExternalRepositoryManager.
:: ---------------------------------------------------------------------------
call "%REPOSITORY_ROOT%Integrate\Repository\Tools\GitExternalRepositoryManager\setup.cmd"

:: ---------------------------------------------------------------------------
:: Setup GitExternalScripts.
:: ---------------------------------------------------------------------------
call "%REPOSITORY_ROOT%Integrate\Repository\Tools\GitExternalScripts\setup.cmd"

:: ---------------------------------------------------------------------------
:: Setup GitMirror.
:: ---------------------------------------------------------------------------
call "%REPOSITORY_ROOT%Integrate\Repository\Tools\GitMirror\setup.cmd"

:success
exit /B 0

:error
pause
exit /B 1
