@echo off
:: Copyright (C)2013 Nintendo Co., Ltd.  All rights reserved.
:: 
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.

%~d0
cd %~p0

set SCRIPT_PATH=.\Integrate\Scripts\Invoke-CIBuild.ps1
set POWERSHELL=powershell -ExecutionPolicy RemoteSigned

if "%1" == "merge-check" (
    set MergeCondition[0]=Generic,build_default
    set MergeCondition[1]=Generic,test_module
    set MergeCondition[2]=NX,build_documents
    set MergeCondition[3]=NX,build_default
    set MergeCondition[4]=NX,build_packages_target-test
    set MergeCondition[5]=NX,build_packages_test-binaries-a64
    set MergeCondition[6]=NX,build_packages_MinSdk

    setlocal EnableDelayedExpansion
    for /L %%i in (0,1,6) do (
        for /f "delims=, tokens=1,2" %%1 in ('echo %%MergeCondition[%%i]%%') do (
            %POWERSHELL% %SCRIPT_PATH% -Spec %%1 -JobName %%2
            if not !ERRORLEVEL! == 0 (
                echo fail
                exit /b !ERRORLEVEL!
            )
        )
    )
) else (
    %POWERSHELL% %SCRIPT_PATH% %*
)
