﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#version 440

mat4 IdentityMatrix =
mat4( 0.5, 0.0, 0.0, 0.0,
      0.0, 0.5, 0.0, 0.0,
      0.0, 0.0, 0.5, 0.0,
      0.5, 0.5, 0.5, 1.0 );

#define M_PI 3.14159265358979323846264

layout( location = 0 ) in Raster
{
    vec3 pos_w;
    vec3 normal;
    vec3 normal_w;
    vec3 tangent_w;
    vec3 binormal_w;
    vec3 eye2pos_w;
    vec4 color;
    vec4 uv;
    vec4 projection;
} IN;

layout( std140, binding = 3 ) uniform Material
{
    vec4 nwParam0;
    vec4 nwParam1;
    vec4 nwParam2;
    vec4 nwParam3;
    vec4 nwParam4;
    vec4 nwParam5;
    vec4 nwParam6;
    vec4 nwParam7;
    vec4 nwParam8;
    vec4 nwParam9;
    vec4 nwParam10;
    vec4 nwParam11;
};

layout( std140, binding = 2 ) uniform View
{
        mat4                    viewMat;                        //!< view マトリクス
        mat4                    projMat;                        //!< proj マトリクス
        mat4                    vpMat;                          //!< view * proj マトリクス
        mat4                    bldMat;                         //!< ビルボードマトリクス
        vec4                    cameraVec;                      //!< 視線ベクトル
        vec4                    cameraPos;                      //!< 視線位置
        vec4                    viewParam;                      //!< near / far / near * far / far - near /
        vec4                    viewParam2;                     //!< baseFovy / currentFovy / zOffset (Avoid Z-Fighting)
};

float CalcFresnelRate( vec3 eyeVec, vec3 worldNormal )
{
    #define fresnelAlphaMin         0.0
    #define fresnelAlphaMax         1.0
    vec3  worldDir = normalize( eyeVec );
    float rotDiff = abs( dot( worldNormal, worldDir.xyz ) );
    float fresnel = smoothstep( fresnelAlphaMin, fresnelAlphaMax, rotDiff );
    return fresnel;
}

#define _USE_NN_VFX
layout( location = 0 ) out vec4 nwOutputAlbedoColor;
#define OUTPUT_COLOR nwOutputAlbedoColor

uniform sampler2D _a0;
uniform sampler2D _a1;
uniform sampler2D _a2;
uniform sampler2D _a3;

#define nwAlbedoTexture0 _a0
#define nwAlbedoTexture1 _a1
#define nwAlbedoTexture2 _a2
#define nwAlbedoTexture3 _a3

uniform sampler2D nwColorBufferTexture;
uniform sampler2D nwDepthBufferTexture;
#define sysTextureSampler0 nwAlbedoTexture0
#define sysTextureSampler1 nwAlbedoTexture1
#define sysTextureSampler2 nwAlbedoTexture2
#define sysFrameBufferTexture nwColorBufferTexture
#define sysDepthBufferTexture nwDepthBufferTexture
#define nwTextureCoord0 IN.uv.xy
#define nwTextureCoord1 IN.uv.xy
#define nwTextureCoord2 IN.uv.xy
#define nwTextureCoord3 IN.uv.xy
#define sysTexCoord01Vary IN.uv
#define sysTexCoord2Vary IN.uv.xy
#define sysLifeRatio nwParam0.x
#define sysFragCoordVary IN.projection
#define sysWorldPositionVary IN.pos_w
#define sysWorldNormalVary IN.normal_w
#define sysWorldTangentVary IN.tangent_w
#define sysWorldBinormalVary IN.binormal_w
#define v_outWorldNormal IN.normal_w
#define sysViewMatrix viewMat
#define v_outPrimitiveColor nwParam3
#define sysShaderAnim nwParam0.y
#define sysShaderAnimY nwParam0.z
#define sysShaderAnimZ nwParam0.w
#define emitterMatrixRT IdentityMatrix
#define sysEmitterRTMatrix IdentityMatrix
#define eyePos cameraPos
#define eyeVec cameraVec
#define sysEyeVecVary eye2pos_w
#define v_outColor0 nwParam1
#define v_outColor1 nwParam2
#define sysParticleRandom nwParam3
#define sysFragRandomVary nwParam3
#define sysProjectionMatrix projMat
#define nwConstantColor0 nwParam7;
#define nwConstantColor1 nwParam1;
#define nwConstantColor2 nwParam2;
#define nwConstantColor3 nwParam3;
#define nwConstantColor4 nwParam4;
#define nwConstantColor5 nwParam5;
#define nwConstantColor6 nwParam6;
#define vColor nwParam8;
#define cameraPosition cameraPos.xyz
#define viewM cameraMtx43
#define modelViewM cameraMtx43
#define sysScreenNear           viewParam.x                 // screen near
#define sysScreenFar            viewParam.y                 // screen far
#define sysScreenFarMultNearFar viewParam.z                 // screen near * far
#define sysScreenSubFarNear     viewParam.w                 // screen far  - near

// nw_def コンパイル通し用
float       nwTimeRatio;

// カールノイズテクスチャアレイサンプラ―( コンパイル通し用 )
uniform sampler3D sysCurlNoiseTextureArray;

vec3 GetSysWorldNormalVary()
{
    vec3 normal = sysWorldNormalVary;
    return normalize( normal );
}

float CalcAlphaProcess( float inAlpha )
{
    return inAlpha;
}

void FinalAdjustmentFragmentColor() {}

float GetDepthValue( vec4 position )
{
    // 射影変換結果を varying 変数で持ってきているので、深度値化に position.w で除算するのが必要
    // ※ 頂点シェーダのテクスチャ座標変換で [-1,1] -> [0,1] に変換されてるがこれはOK？
    float depth = position.z / position.w;
    // [0,1] -> [Near,Far] の値域に Map。Near は0に近い（0.1とか）ので、実質[0, Far] の近似ともみなせる。
    // ※ EffectMaker/Viewer のデフォルト設定では [0.1, 1000] の値域になる。
    depth = - ( sysScreenFarMultNearFar ) / ( depth * ( sysScreenSubFarNear ) - sysScreenFar );
    return depth;
}

float GetDepthValueFromTexture( vec4 projection )
{
    float depth = texture2DProj( sysDepthBufferTexture, projection ).r;
    depth = - ( sysScreenFarMultNearFar ) / ( depth * ( sysScreenSubFarNear ) - sysScreenFar );
    return depth;
}

//-----------------------------------------------------
// TODO : ui2d コンパイル通し用
//-----------------------------------------------------
vec4 modelM[3] = {
    vec4(1.0, 0.0, 0.0, 0.0),
    vec4(0.0, 1.0, 0.0, 0.0),
    vec4(0.0, 0.0, 1.0, 0.0),
};
int   userData_i0 = 0;
int   userData_i1 = 0;
int   userData_i2 = 0;
int   userData_i3 = 0;
ivec2 userData_ivec2[4] = { ivec2(0), ivec2(0), ivec2(0), ivec2(0) };
ivec4 userData_rgba[4] = { ivec4(0), ivec4(0), ivec4(0), ivec4(0) };
float userData_f0 = 0.0;
float userData_f1 = 0.0;
float userData_f2 = 0.0;
float userData_f3 = 0.0;
vec2  userData_vec2[4] = { vec2(0.0), vec2(0.0), vec2(0.0), vec2(0.0) };
vec3  userData_vec3[4] = { vec3(0.0), vec3(0.0), vec3(0.0), vec3(0.0) };
