﻿/// <header>
///   <version>0.0.0</version>
/// </header>

/// <tag name="Divide">
///   <func id="DivF4"/>
/// </tag>
/// <func id="DivF4" name="DivF4">
///   <out name="f0" type="float"/>
///   <out name="f1" type="float"/>
///   <out name="f2" type="float"/>
///   <out name="f3" type="float"/>
///   <in name="v4" type="vec4"/>
///   <description>vec4 を各要素に分解</description>
/// </func>
/// <block guid="{48922679-4DFC-4E94-85E5-150A92743A9F}" displayname="DivF4">
///   <func id="DivF4"/>
///   <out displayname="x" type="float" target="f0"/>
///   <out displayname="y" type="float" target="f1"/>
///   <out displayname="z" type="float" target="f2"/>
///   <out displayname="w" type="float" target="f3"/>
///   <in displayname="vec4" type="vec4" target="v4"/>
/// </block>
/// <code funcid="DivF4">
void DivF4( out float f0, out float f1, out float f2, out float f3, vec4 v4 )
{
  f0  = v4.x;
  f1  = v4.y;
  f2  = v4.z;
  f3  = v4.w;
}
/// </code>

/// <tag name="Divide">
///   <func id="DivF3"/>
/// </tag>
/// <func id="DivF3" name="DivF3">
///   <out name="f0" type="float"/>
///   <out name="f1" type="float"/>
///   <out name="f2" type="float"/>
///   <in name="v3" type="vec3"/>
///   <description>vec3 を各要素に分解</description>
/// </func>
/// <block guid="{48932679-4DFC-4E96-85E5-150A93743A9F}" displayname="DivF3">
///   <func id="DivF3"/>
///   <out displayname="x" type="float" target="f0"/>
///   <out displayname="y" type="float" target="f1"/>
///   <out displayname="z" type="float" target="f2"/>
///   <in displayname="vec3" type="vec3" target="v3"/>
/// </block>
/// <code funcid="DivF3">
void DivF3( out float f0, out float f1, out float f2, vec3 v3 )
{
  f0 = v3.x;
  f1 = v3.y;
  f2 = v3.z;
}
/// </code>

/// <tag name="Divide">
///   <func id="DivF2"/>
/// </tag>
/// <func id="DivF2" name="DivF2">
///   <out name="f0" type="float"/>
///   <out name="f1" type="float"/>
///   <in name="v2" type="vec2"/>
///   <description>vec2 を各要素に分解</description>
/// </func>
/// <block guid="{48933679-4DFC-4E96-85E5-150A93743A9F}" displayname="DivF2">
///   <func id="DivF2"/>
///   <out displayname="x" type="float" target="f0"/>
///   <out displayname="y" type="float" target="f1"/>
///   <in displayname="vec2" type="vec2" target="v2"/>
/// </block>
/// <code funcid="DivF2">
void DivF2( out float f0, out float f1, vec2 v2 )
{
  f0 = v2.x;
  f1 = v2.y;
}
/// </code>

/// <tag name="Divide">
///   <func id="DivV3F"/>
/// </tag>
/// <func id="DivV3F" name="DivV3F">
///   <out name="v3" type="vec3"/>
///   <out name="f" type="float"/>
///   <in name="v4" type="vec4"/>
///   <description>vec4 を vec3(xyz) と w要素に分解</description>
/// </func>
/// <block guid="{48922679-3DFC-4E94-85E5-150A92743A9F}" displayname="DivV3F">
///   <func id="DivV3F"/>
///   <out displayname="xyz" type="vec3" target="v3"/>
///   <out displayname="w" type="float" target="f"/>
///   <in displayname="vec4" type="vec4" target="v4"/>
/// </block>
/// <code funcid="DivV3F">
void DivV3F( out vec3 v3, out float f, vec4 v4 )
{
  v3 = v4.xyz;
  f  = v4.w;
}
/// </code>

/// <tag name="Divide">
///   <func id="DivV2F"/>
/// </tag>
/// <func id="DivV2F" name="DivV2F">
///   <out name="v2" type="vec2"/>
///   <out name="f" type="float"/>
///   <in name="v3" type="vec3"/>
///   <description>vec3 を vec2(xy) と z要素に分解</description>
/// </func>
/// <block guid="{48922679-3DFD-4E95-85E5-150A92743A9F}" displayname="DivV2F">
///   <func id="DivV2F"/>
///   <out displayname="xy" type="vec2" target="v2"/>
///   <out displayname="z" type="float" target="f"/>
///   <in displayname="vec3" type="vec3" target="v3"/>
/// </block>
/// <code funcid="DivV2F">
void DivV2F( out vec2 v2, out float f, vec3 v3 )
{
  v2 = v3.xy;
  f  = v3.z;
}
/// </code>

