-- NintendoExport Node Options Script
-- Version 3.12.0
-- Copyright (C)Nintendo All rights reserved.

rcMenu nw4fNodeMenu
(
	subMenu "Help" 
	(
		menuItem mi_Help "Help On Set No Compress Node..."
	)
	on mi_Help picked do nintendoExportRollout.showHelp @"html\NW4F_SetNoCompressNode.html"
)
rollout nw4fNodeRollout "Set No Compress Node" width:320 height:348
(
	groupBox grp1 "Selected Nodes" pos:[8,8] width:304 height:188
	--label lblSelectedNode "" pos:[16,24] width:288 height:64
	dotNetControl lv_mtl "System.Windows.Forms.ListView" pos:[16,24] width:288 height:164
	groupBox grp2 "Set" pos:[8,204] width:304 height:48
	dropDownList ddlSetCompress "" pos:[16,220] width:200 height:22 items:#("Compress this node if possible","Don't compress this node")
	groupBox grp3 "Search" pos:[8,260] width:304 height:52
	radioButtons rdoSearch "" pos:[16,276] width:208 height:16 labels:#("Compress If Possible", "Don't Compress") columns:1
	button btnSearch "Search" pos:[226,284] width:80 height:24
	button btnClose "Close" pos:[8,320] width:304 height:24

	local donotRedraw
	local nodes = #()
	
	fn initListView =
	(
		lv_mtl.gridLines = true
		lv_mtl.View = (dotNetClass "System.Windows.Forms.View").Details
		lv_mtl.fullRowSelect = true
		lv_mtl.AutoSize = true
		lv_mtl.MultiSelect = false
		lv_mtl.Columns.add "Node Name        "
		lv_mtl.Columns.add "Compress"
		lv_mtl.sorting = (dotNetClass "System.Windows.Forms.SortOrder").Ascending
		lv_mtl.AutoResizeColumns ((dotNetClass "System.Windows.Forms.ColumnHeaderAutoResizeStyle").HeaderSize)
	)

	fn getNodeAttribute n create =
	(
		local attrib = n.custAttributes["NW4F Node Custom Attribute"]
		if attrib == undefined then
		(
			if not create do return undefined
			attrib = nw4f_node_custom_attribute()
			append n.custAttributes attrib
		)
		return attrib
	)
	
	fn setNodeNoCompress n flag =
	(
		local attrib = getNodeAttribute n true
		if attrib == undefined do return undefined
		attrib.noCompress = flag
	)

	fn getNodeNoCompress n =
	(
		local attrib = getNodeAttribute n false
		if attrib == undefined do return false
		return attrib.noCompress
	)

	fn updateSelection =
	(
		if donotRedraw do return()
		lv_mtl.Items.Clear()
		local lvItems =#()

		local str = ""
		for n in nodes do
		(
			local flag = getNodeNoCompress n

			local li = dotNetObject "System.Windows.Forms.ListViewItem" n.name
			local sub_li 
			
			str = case flag of
				(
					true: "Don't compress"
					default: "If possible"
				)
			sub_li = li.SubItems.add str
			append lvItems li
		)
		lv_mtl.Items.AddRange lvItems 

		if nodes.count > 0 then
		(
			ddlSetCompress.enabled = true
			ddlSetCompress.selection =  case getNodeNoCompress nodes[1] of
			(
				true: 2
				false: 1
			)
		)
		else
		(
			ddlSetCompress.enabled = false
		)
	)
	
	
	on ddlSetCompress selected i do
	(
		local v = case i of
		(
			1: false
			2: true
		)
		for n in nodes do
		(
			setNodeNoCompress n v
		)
		updateSelection()
	)
	
	fn selectionCallback = 
	(
		nodes = #()
		for n in selection do appendIfUnique nodes n
		updateSelection()
	)
	
	on nw4fNodeRollout open  do
	(
		donotRedraw = false
		initListView()
		nodes = #()
		callbacks.addScript #selectionSetChanged "nw4fNodeRollout.selectionCallback()" id:#nw4fNodeSelectionChange
		selectionCallback()
	)
	on nw4fNodeRollout close  do
	(
		callbacks.removeScripts id:#nw4fNodeSelectionChange
	)
	on btnSearch pressed  do
	(
		donotRedraw = true
		clearSelection()
		nodes = #()
		local flag = (rdoSearch.state == 2)
		for n in objects do
		(
			if (getNodeNoCompress n) == flag do
			(
				selectMore n
				appendIfUnique nodes n
			)
		)
		donotRedraw = false
		updateSelection()
	)
	on btnClose pressed  do DestroyDialog nw4fNodeRollout
)-- node rollout

rcMenu nw4fShapeAnimMenu
(
	subMenu "Help" 
	(
		menuItem mi_Help "Help On Set Shape Animation..."
	)
	on mi_Help picked do nintendoExportRollout.showHelp @"html\NW4F_SetShapeAnimation.html"
)
rollout nw4fShapeAnimRollout "Set Shape Animation" width:320 height:270
(
	
	group "Selected Nodes"
	(
		dotNetControl lv_nodes "System.Windows.Forms.ListView" width:288 height:164
	)
	group "Set"
	(
		label lblUpdateShape "Update " across:4
		checkbox chkExportShapePosition "Position"
		checkbox chkExportShapeNormal "Normal"
		checkbox chkExportShapeColor "Color"
	)
	button btnClose "Close"  width:304 height:24

	local donotRedraw
	local nodes = #()
	
	fn initListView =
	(
		lv_nodes.gridLines = true
		lv_nodes.View = (dotNetClass "System.Windows.Forms.View").Details
		lv_nodes.fullRowSelect = true
		lv_nodes.AutoSize = true
		lv_nodes.MultiSelect = false
		lv_nodes.Columns.add "Node Name        "
		lv_nodes.Columns.add "Position"
		lv_nodes.Columns.add "Normal"
		lv_nodes.Columns.add "Color"
		lv_nodes.sorting = (dotNetClass "System.Windows.Forms.SortOrder").Ascending
		lv_nodes.AutoResizeColumns ((dotNetClass "System.Windows.Forms.ColumnHeaderAutoResizeStyle").HeaderSize)
	)

	fn getNodeAttribute n create =
	(
		local attrib = n.custAttributes["NW4F Node Custom Attribute"]
		if attrib == undefined then
		(
			if not create do return undefined
			attrib = nw4f_node_custom_attribute()
			append n.custAttributes attrib
		)
		return attrib
	)
	
	fn setExportShapePosition n flag =
	(
		local attrib = getNodeAttribute n true
		if attrib == undefined do return undefined
		attrib.exportShapePosition = flag
	)

	fn getExportShapePosition n =
	(
		local attrib = getNodeAttribute n false
		if attrib == undefined do return true -- ftHgo[true
		return attrib.exportShapePosition
	)

	fn setExportShapeNormal n flag =
	(
		local attrib = getNodeAttribute n true
		if attrib == undefined do return undefined
		attrib.exportShapeNormal = flag
	)

	fn getExportShapeNormal n =
	(
		local attrib = getNodeAttribute n false
		if attrib == undefined do return true -- ftHgo[true
		return attrib.exportShapeNormal
	)

	fn setExportShapeColor n flag =
	(
		local attrib = getNodeAttribute n true
		if attrib == undefined do return undefined
		attrib.exportShapeColor = flag
	)

	fn getExportShapeColor n =
	(
		local attrib = getNodeAttribute n false
		if attrib == undefined do return false
		return attrib.exportShapeColor
	)

	fn updateSelection =
	(
		if donotRedraw do return()
		lv_nodes.Items.Clear()
		local lvItems =#()

		local str = ""
		
		for n in nodes do
		(
			local li = dotNetObject "System.Windows.Forms.ListViewItem" n.name
			local sub_li 
			local attr = getNodeAttribute n false
			sub_li = li.SubItems.add ((getExportShapePosition n) as string)
			sub_li = li.SubItems.add ((getExportShapeNormal n) as string)
			sub_li = li.SubItems.add ((getExportShapeColor n) as string)
			
			/*
			if attr != undefined then --Agr[gꍇ
			(
				sub_li = li.SubItems.add (attr.exportTranslateKey as string)
				sub_li = li.SubItems.add (attr.exportRotateKey as string)
				sub_li = li.SubItems.add (attr.exportScaleKey as string)
				sub_li = li.SubItems.add (attr.exportVisibilityKey as string)
			)
			else -- Agr[gȂꍇ
			(
				sub_li = li.SubItems.add "false"
				sub_li = li.SubItems.add "false"
				sub_li = li.SubItems.add "false"
				sub_li = li.SubItems.add "false"
			)
			*/
			append lvItems li
		)
		lv_nodes.Items.AddRange lvItems 

		if nodes.count > 0 then
		(
			local n = nodes[1]
			chkExportShapePosition.enabled = true
			chkExportShapeNormal.enabled = true
			chkExportShapeColor.enabled = true
			chkExportShapePosition.checked = getExportShapePosition n
			chkExportShapeNormal.checked = getExportShapeNormal n
			chkExportShapeColor.checked = getExportShapeColor n
		)
		else
		(
			chkExportShapePosition.enabled = false
			chkExportShapeNormal.enabled = false
			chkExportShapeColor.enabled = false
		)
	)

	fn setSelection =
	(
		for n in nodes do
		(
			setExportShapePosition n chkExportShapePosition.checked
			setExportShapeNormal n chkExportShapeNormal.checked
			setExportShapeColor n chkExportShapeColor.checked
		)
		
		updateSelection()
	)


	
	fn selectionCallback = 
	(
		nodes = #()
		for n in selection do
		(
			local isMorph = false
			for m in n.modifiers while (not isMorph) do
			(
				if (classof m) == Morpher do  isMorph = true
			)
			if isMorph do appendIfUnique nodes n
		)

		updateSelection()
	)
	
	on chkExportShapePosition changed v do setSelection()
	on chkExportShapeNormal changed v do setSelection()
	on chkExportShapeColor changed v do setSelection()
	
	on nw4fShapeAnimRollout open  do
	(
		donotRedraw = false
		initListView()
		nodes = #()
		callbacks.addScript #selectionSetChanged "nw4fShapeAnimRollout.selectionCallback()" id:#nw4fShapeAnimSelectionChange
		selectionCallback()
	)
	on nw4fShapeAnimRollout close  do
	(
		callbacks.removeScripts id:#nw4fShapeAnimSelectionChange
	)
	on btnClose pressed  do DestroyDialog nw4fShapeAnimRollout
)-- shape rollout

rollout nw4fBillboardRollout "Set Billboard" width:320 height:400
(
	groupBox grp1 "Selected Nodes" pos:[8,8] width:304 height:188
	--label lblSelectedNode "" pos:[16,24] width:288 height:64
	dotNetControl lv_mtl "System.Windows.Forms.ListView" pos:[16,24] width:288 height:164
	groupBox grp2 "Set" pos:[8,204] width:304 height:48
	dropDownList ddlSetBillboard "" pos:[16,220] width:200 height:22 \
		items:#("Off","World","World Viewpoint","Screen","Screen Viewpoint","Y Axial","Y Axial Viewpoint")
	groupBox grp3 "Search" pos:[8,260] width:304 height:100
	--radioButtons rdoSearch "" pos:[16,276] width:208 height:16 labels:#("Compress If Possible", "Don't Compress") columns:1
	checkbox chkWorld "World" pos:[16,276] width:80 height:16
	checkbox chkWorldView "World Viewpoint" pos:[100,276] width:120 height:16
	checkbox chkScreen "Screen" pos:[16,294] width:80 height:16
	checkbox chkScreenView "Screen Viewpoint" pos:[100,294] width:120 height:16
	checkbox chkYAxial "Y Axial" pos:[16,312] width:80 height:16
	checkbox chkYAxialView "Y Axial Viewpoint" pos:[100,312] width:120 height:16
	
	button btnSearch "Search" pos:[226,284] width:80 height:24
	button btnClose "Close" pos:[8,370] width:304 height:24

	local donotRedraw
	local nodes = #()
	
	fn initListView =
	(
		lv_mtl.gridLines = true
		lv_mtl.View = (dotNetClass "System.Windows.Forms.View").Details
		lv_mtl.fullRowSelect = true
		lv_mtl.AutoSize = true
		lv_mtl.MultiSelect = false
		lv_mtl.Columns.add "Node Name        "
		lv_mtl.Columns.add "Billboard Type"
		lv_mtl.sorting = (dotNetClass "System.Windows.Forms.SortOrder").Ascending
		lv_mtl.AutoResizeColumns ((dotNetClass "System.Windows.Forms.ColumnHeaderAutoResizeStyle").HeaderSize)
	)

	fn getNodeAttribute n create =
	(
		local attrib = n.custAttributes["NW4F Node Custom Attribute"]
		if attrib == undefined then
		(
			if not create do return undefined
			attrib = nw4f_node_custom_attribute()
			append n.custAttributes attrib
		)
		return attrib
	)
	
	fn setNodeBillboardType n flag =
	(
		local attrib = getNodeAttribute n true
		if attrib == undefined do return undefined
		attrib.billboardType = flag
	)

	fn getNodeBillboardType n =
	(
		local attrib = getNodeAttribute n false
		if attrib == undefined do return 0
		return attrib.billboardType
	)

	fn updateSelection =
	(
		if donotRedraw do return()
		lv_mtl.Items.Clear()
		local lvItems =#()

		local str = ""
		for n in nodes do
		(
			local type = getNodeBillboardType n

			local li = dotNetObject "System.Windows.Forms.ListViewItem" n.name
			local sub_li 
			
			str = case type of
				(
					1: "World"
					2: "World Viewpoint"
					3: "Screen"
					4: "Screen Viewpoint"
					5: "Y Axial"
					6: "Y Axial Viewpoint"
					default: "Off"
				)
			sub_li = li.SubItems.add str
			append lvItems li
		)
		lv_mtl.Items.AddRange lvItems 

		if nodes.count > 0 then
		(
			ddlSetBillboard.enabled = true
			ddlSetBillboard.selection =  getNodeBillboardType nodes[1]  + 1
		)
		else
		(
			ddlSetBillboard.enabled = false
		)
	)
	
	on ddlSetBillboard selected i do
	(
		local v = i - 1
		for n in nodes do
		(
			setNodeBillboardType n v
		)
		updateSelection()
	)
	
	fn selectionCallback = 
	(
		nodes = #()
		for n in selection do appendIfUnique nodes n
		updateSelection()
	)
	
	on nw4fBillboardRollout open  do
	(
		donotRedraw = false
		initListView()
		nodes = #()
		for n in selection do appendIfUnique nodes n
		callbacks.addScript #selectionSetChanged "nw4fBillboardRollout.selectionCallback()" id:#nw4fBillboardSelectionChange
		updateSelection()
	)
	on nw4fBillboardRollout close  do
	(
		callbacks.removeScripts id:#nw4fBillboardSelectionChange
	)
	on btnSearch pressed  do
	(
		donotRedraw = true
		clearSelection()
		nodes = #()
		for n in objects do
		(
			local flag = case (getNodeBillboardType n) of
			(
				1: chkWorld.checked--"World"
				2: chkWorldView.checked --"World Viewpoint"
				3: chkScreen.checked --"Screen"
				4: chkScreenView.checked --"Screen Viewpoint"
				5: chkYAxial.checked --"Y Axial"
				6: chkYAxialView.checked --"Y Axial Viewpoint"
				default: false --"Off"
			)
			if flag do
			(
				selectMore n
				appendIfUnique nodes n
			)
		)
		donotRedraw = false
		updateSelection()
	)
	on btnClose pressed  do DestroyDialog nw4fBillboardRollout
	on lv_mtl SelectedIndexChanged e do
	(
		local numItems = lv_mtl.Items.Count
		for i = 0 to (numItems - 1) do
		(
			lv_mtl.Items.Item[i].Selected = false
		)
	)
)-- billboard rollout

rollout nw4fCombineRollout "Set Combine Group" width:320 height:386
(

	groupBox grp1 "Selected Node" pos:[8,8] width:304 height:188
	dotNetControl lv_mtl "System.Windows.Forms.ListView" pos:[16,24] width:288 height:164
	groupBox grp2 "Set" pos:[8,204] width:304 height:64
	label lbl6 "Combine Group:" pos:[16,220] width:104 height:16
	radioButtons rdoSetCombineType "" pos:[100,220] width:87 height:32 labels:#("Don't care", "") columns:1 default:1
	spinner spnSetCombine "" pos:[124,236] width:56 height:16 range:[0,255,0] type:#integer scale:1 enabled:false
	button btnSequential "Set Sequential" pos:[188,236] width:112 height:24

	groupBox grp3 "Search" pos:[8,276] width:304 height:80
	label lbl8 "Combine Group:" pos:[16,292] width:104 height:16
	radioButtons rdoSearchCombineType "" pos:[100,292] width:89 height:48 
			labels:#("Don't care", "Condition") columns:1 default:1 \
	dropDownList ddlSearchConditionType "" pos:[180,304] width:80 height:22 default:1 \ --enabled:false \
			items:#("< : under", "<= : below", "= : exactly", ">= : above", "> : over") 
	spinner spnSearchCombine "" pos:[260,306] width:48 height:16 range:[0,255,0] type:#integer scale:1 --enabled:false
	button btnSearch "Search" pos:[180,328] width:112 height:24

	button btnClose "Close" pos:[8,360] width:304 height:24

	local donotRedraw
	local nodes = #()
	fn initListView =
	(
		lv_mtl.gridLines = true
		lv_mtl.View = (dotNetClass "System.Windows.Forms.View").Details
		lv_mtl.fullRowSelect = true
		lv_mtl.AutoSize = true
		lv_mtl.MultiSelect = false
		lv_mtl.Columns.add "Node Name        "
		lv_mtl.Columns.add "Combine Group"
		lv_mtl.sorting = (dotNetClass "System.Windows.Forms.SortOrder").Ascending
		lv_mtl.AutoResizeColumns ((dotNetClass "System.Windows.Forms.ColumnHeaderAutoResizeStyle").HeaderSize)
	)

	fn getNodeAttribute n create =
	(
		local attrib = n.custAttributes["NW4F Node Custom Attribute"]
		if attrib == undefined then
		(
			if not create do return undefined
			attrib = nw4f_node_custom_attribute()
			append n.custAttributes attrib
		)
		return attrib
	)
	
	fn setNodeCombineGroup n id =
	(
		local attrib = getNodeAttribute n true
		if attrib == undefined do return undefined
		attrib.combineGroup = id
	)

	fn getNodeCombineGroup n =
	(
		local attrib = getNodeAttribute n false
		if attrib == undefined do return -1
		return attrib.combineGroup
	)
	
	fn updateSelection =
	(
		if donotRedraw do return()
		lv_mtl.Items.Clear()
		local lvItems =#()

		local str = ""
		for n in nodes do
		(
			local id = getNodeCombineGroup n

			local li = dotNetObject "System.Windows.Forms.ListViewItem" n.name
			local sub_li 
			
			str = if (id < 0) then "Don't care"
					else str = (id as string)
			sub_li = li.SubItems.add str
			append lvItems li
		)
		lv_mtl.Items.AddRange lvItems 

		if nodes.count > 0 then
		(
			id = getNodeCombineGroup nodes[1]
			--print nodes
			if (id < 0) then
			(
				rdoSetCombineType.state =  1
				spnSetCombine.enabled = false
			)
			else
			(
				rdoSetCombineType.state =  2
				spnSetCombine.enabled = true
				spnSetCombine.value = id
			)
		)
	)
	
	fn setNodesAttribute =
	(
		--local mtls = getSelMtls selection
		local attr
		undo "Edit Combine Group" on
		(
			spnSetCombine.enabled = (rdoSetCombineType.state == 2)
			for n in nodes do
			(
				attr = getNodeAttribute n true
				local val = 0
				if rdoSetCombineType.state == 1 then
				(
					attr.combineGroup = -1
				)
				else
				(
					attr.combineGroup = spnSetCombine.value
				)
			)
		)
		updateSelection()
	)

	fn nodeNameCompare v1 v2 =
	(
		if (v1.name > v2.name) then 1 else -1
	)
	
	fn addCallback = 
	(
		callbacks.addScript #selectionSetChanged "nw4fCombineRollout.selectionCallback()" \
			id:#nw4fCombineSelectionChange
	)
	fn removeCallback = 
	(
		callbacks.removeScripts id:#nw4fCombineSelectionChange
	)
	
	fn selectionCallback = 
	(
		--print "selectionCallback"
		nodes = #()
		for n in selection do appendIfUnique nodes n
		qsort nodes nodeNameCompare
		updateSelection()
	)
	
	fn sequenceCompare v1 v2 =
	(
		local ret = 0
		if(v1[1] > v2[1]) then
		(
			ret = 1
		)
		else if (v1[1] < v2[1]) then
		(
			ret = -1
		)
		else
		(
			ret = if (v1[2].name > v2[2].name) then 1 else -1
		)
		ret
	)
	
	on btnSequential pressed do
	(
		local seqnodes = #()
		local id = spnSetCombine.value
		-- O[vID255𒴂ꍇ̓G[
		if (id + nodes.count - 1) > 255 then
		(
			messageBox "Combine Group will be greater than 255"
			return()
		)
		
		for n in nodes do
		(
			local depth = 0
			local p = n
			do
			(
				depth += 1
				p = p.parent
			)
			while (p != undefined)
			append seqnodes #(depth, n)
		)
		qsort seqnodes sequenceCompare
		--print seqnodes
		for a in seqnodes do
		(
			setNodeCombineGroup a[2] id
			id += 1
		)
		updateSelection()
	)
	
	on btnSearch pressed  do 
	(
		removeCallback()
		clearSelection()
		nodes = #()
		for n in objects do
		(
			--local attr = getNodeAttribute n false
			local id = getNodeCombineGroup n
			local ret= false
			
			case rdoSearchCombineType.state of
			(
				1: ( -- Don't care
					if id < 0 do
					(
						ret = true
					)
				)
				2: ( -- condition
					if id >=0 do
					(
						local v = spnSearchCombine.value
						case ddlSearchConditionType.selection of
						(
							1: ( -- under
								ret = (id < v)
							)
							2: ( -- below
								ret = (id <= v)
							)
							3: ( -- exactly
								ret = (id == v)
							)
							4: ( -- above
								ret = (id >= v)
							)
							5: ( -- over
								ret = (id > v)
							)
						)
					)
				)
				default: ret = false
			)
			
			-- 𖞂΃}eAzɒǉ
			if ret do
			(
				appendIfUnique nodes n
			)
		)

		for n in nodes do
		(
			selectMore n
		)

		updateSelection()
		addCallback()
	)

	on rdoSetCombineType changed i do setNodesAttribute()
	on spnSetCombine changed i do setNodesAttribute()
	
	on nw4fCombineRollout open  do
	(
		donotRedraw = false
		initListView()
		nodes = #()
		addCallback()
		selectionCallback()
	)
	on nw4fCombineRollout close  do
	(
		removeCallback()
	)

	on btnClose pressed  do DestroyDialog nw4fCombineRollout
)-- combine rollout

rollout nw4fForceKeyRollout "Set Force Export Key" width:320 height:450
(
	group "Selected Nodes"
	(
		dotNetControl lv_nodes "System.Windows.Forms.ListView" width:288 height:164
	)
	group "Set"
	(
		checkbox chkExportTrans "Force Export Translate Key" width:280 height:16 offset:[0,-4]
		checkbox chkExportRotate "Force Export Rotate Key" width:280 height:16 offset:[0,-4]
		checkbox chkExportScale "Force Export Scale Key" width:280 height:16 offset:[0,-4]
		checkbox chkExportVisibility "Force Export Visibility Key" width:280 height:16 offset:[0,-4]
	)
	group "Search"
	(
		label lblExportTrans "Force Export Translate Key" align:#left  across:4
		label lblDummy3 ""
		checkbox chkS_ExportTransOFF "Off"
		checkbox chkS_ExportTransON "On"
		label lblExportRotate "Force Export Rotate Key"  align:#left  across:4
		label lblDummy2 ""
		checkbox chkS_ExportRotateOFF "Off" 
		checkbox chkS_ExportRotateON "On" 
		label lblExportScale "Force Export Scale Key" align:#left across:4 
		label lblDummy1 ""
		checkbox chkS_ExportScaleOFF "Off"
		checkbox chkS_ExportScaleON "On"
		label lblExportVis "Force Export Visibility Key" align:#left across:4 
		label lblDummy4 ""
		checkbox chkS_ExportVisOFF "Off"
		checkbox chkS_ExportVisON "On"
		
		radioButtons rdoSearchType "" width:98 height:16 labels:#("AND", "OR") columns:2 offset:[0,4] across:2
		button btnSearch "Search" width:112 height:24
	)

	button btnClose "Close" width:304 height:24
		
	local donotRedraw
	local nodes = #()
	fn initListView =
	(
		lv_nodes.gridLines = true
		lv_nodes.View = (dotNetClass "System.Windows.Forms.View").Details
		lv_nodes.fullRowSelect = true
		lv_nodes.AutoSize = true
		lv_nodes.MultiSelect = false
		lv_nodes.Columns.add "Node Name  "
		lv_nodes.Columns.add "Translate"
		lv_nodes.Columns.add "Rotate"
		lv_nodes.Columns.add "Scale"
		lv_nodes.Columns.add "Visibility"
		lv_nodes.sorting = (dotNetClass "System.Windows.Forms.SortOrder").Ascending
		lv_nodes.AutoResizeColumns ((dotNetClass "System.Windows.Forms.ColumnHeaderAutoResizeStyle").HeaderSize)
	)

	fn getNodeAttribute n create =
	(
		local attrib = n.custAttributes["NW4F Node Custom Attribute"]
		if attrib == undefined then
		(
			if not create do return undefined
			attrib = nw4f_node_custom_attribute()
			append n.custAttributes attrib
		)
		return attrib
	)
	
	fn setExportScale n flag =
	(
		local attrib = getNodeAttribute n true
		if attrib == undefined do return undefined
		attrib.exportScaleKey = flag
	)
	fn setExportRotate n flag =
	(
		local attrib = getNodeAttribute n true
		if attrib == undefined do return undefined
		attrib.exportRotateKey = flag
	)
	fn setExportTrans n flag =
	(
		local attrib = getNodeAttribute n true
		if attrib == undefined do return undefined
		attrib.exportTranslateKey = flag
	)
	fn setExportVis n flag =
	(
		local attrib = getNodeAttribute n true
		if attrib == undefined do return undefined
		attrib.exportVisibilityKey = flag
	)
	
	fn getExportScale n =
	(
		local attrib = getNodeAttribute n false
		if attrib == undefined do return false
		return attrib.exportScaleKey
	)
	fn getExportRotate n =
	(
		local attrib = getNodeAttribute n false
		if attrib == undefined do return false
		return attrib.exportRotateKey
	)
	fn getExportTrans n =
	(
		local attrib = getNodeAttribute n false
		if attrib == undefined do return false
		return attrib.exportTranslateKey
	)
	fn getExportVis n =
	(
		local attrib = getNodeAttribute n false
		if attrib == undefined do return false
		return attrib.exportVisibilityKey
	)
	
	fn updateSelection =
	(
		if donotRedraw do return()
		lv_nodes.Items.Clear()
		local lvItems =#()

		local str = ""
		for n in nodes do
		(
			local li = dotNetObject "System.Windows.Forms.ListViewItem" n.name
			local sub_li 
			local attr = getNodeAttribute n false
			if attr != undefined then --Agr[gꍇ
			(
				sub_li = li.SubItems.add (attr.exportTranslateKey as string)
				sub_li = li.SubItems.add (attr.exportRotateKey as string)
				sub_li = li.SubItems.add (attr.exportScaleKey as string)
				sub_li = li.SubItems.add (attr.exportVisibilityKey as string)
			)
			else -- Agr[gȂꍇ
			(
				sub_li = li.SubItems.add "false"
				sub_li = li.SubItems.add "false"
				sub_li = li.SubItems.add "false"
				sub_li = li.SubItems.add "false"
			)
			append lvItems li
		)
		lv_nodes.Items.AddRange lvItems 

		if nodes.count > 0 then
		(
			chkExportScale.enabled = true
			chkExportRotate.enabled = true
			chkExportTrans.enabled = true
			chkExportVisibility.enabled = true
			chkExportScale.checked = getExportScale nodes[1]
			chkExportRotate.checked = getExportRotate nodes[1]
			chkExportTrans.checked = getExportTrans nodes[1]
			chkExportVisibility.checked = getExportVis nodes[1]
		)
		else
		(
			chkExportScale.enabled = false
			chkExportRotate.enabled = false
			chkExportTrans.enabled = false
			chkExportVisibility.enabled = false
		)
	)

	
	on chkExportScale changed v do
	(
		for n in nodes do
		(
			setExportScale n v
		)
		updateSelection()
	)
	on chkExportRotate changed v do
	(
		for n in nodes do
		(
			setExportRotate n v
		)
		updateSelection()
	)
	on chkExportTrans changed v do
	(
		for n in nodes do
		(
			setExportTrans n v
		)
		updateSelection()
	)
	on chkExportVisibility changed v do
	(
		for n in nodes do
		(
			setExportVis n v
		)
		updateSelection()
	)
	
	fn addCallback = 
	(
		callbacks.addScript #selectionSetChanged "nw4fForceKeyRollout.selectionCallback()" \
			id:#nw4fForceKeySelectionChange
	)
	fn removeCallback = 
	(
		callbacks.removeScripts id:#nw4fForceKeySelectionChange
	)
	fn selectionCallback = 
	(
		nodes = #()
		for n in selection do appendIfUnique nodes n
		updateSelection()
	)
	
	on nw4fForceKeyRollout open  do
	(
		donotRedraw = false
		initListView()
		nodes = #()
		addCallback()
		selectionCallback()
	)
	on nw4fForceKeyRollout close  do
	(
		removeCallback()
	)
	on btnSearch pressed  do 
	(
		removeCallback()
		clearSelection()
		nodes = #()
		local bScaleON = chkS_ExportScaleON.checked
		local bScaleOFF = chkS_ExportScaleOFF.checked
		local bRotON = chkS_ExportRotateON.checked
		local bRotOFF = chkS_ExportRotateOFF.checked
		local bTransON = chkS_ExportTransON.checked
		local bTransOFF = chkS_ExportTransOFF.checked
		local bVisON = chkS_ExportVisON.checked
		local bVisOFF = chkS_ExportVisOFF.checked
		
		local scaleKey, rotKey, transKey, visKey
		
		local isSearchAnd = if rdoSearchType.state == 1 then true else false
		local isSearchOr = not isSearchAnd 
			
		for n in objects do
		(
			local attr = getNodeAttribute n false
			if attr == undefined then
			(
				scaleKey = rotKey = transKey = visKey = false
			)
			else
			(
				scaleKey = attr.exportScaleKey
				rotKey = attr.exportRotateKey
				transKey = attr.exportTranslateKey
				visKey = attr.exportVisibilityKey
			)
			
			local compare = true -- ̏Ŕr𑱂邩ǂH
			local ret =false -- ̃m[hr𖞂ǂ
			
			-- scale
			if (bScaleON or bScaleOFF) and compare do
			(
				ret = (scaleKey == bScaleON) or ((not scaleKey) == bScaleOFF)
				if ret and isSearchOr then compare = false
				else if (not ret) and isSearchAnd do compare = false
			)
			-- rotate
			if (bRotON or bRotOFF) and compare do
			(
				ret = (rotKey == bRotON) or ((not rotKey) == bRotOFF)
				if ret and isSearchOr then compare = false
				else if (not ret) and isSearchAnd do compare = false
			)
			-- translate
			if (bTransON or bTransOFF) and compare do
			(
				ret = (transKey == bTransON) or ((not transKey) == bTransOFF)
				if ret and isSearchOr then compare = false
				else if (not ret) and isSearchAnd do compare = false
			)
			-- visibility
			if (bVisON or bVisOFF) and compare do
			(
				ret = (visKey == bVisON) or ((not visKey) == bVisOFF)
				if ret and isSearchOr then compare = false
				else if (not ret) and isSearchAnd do compare = false
			)
			
			-- 𖞂΃m[hzɒǉ
			if ret do
			(
				appendIfUnique nodes n
			)
		)

		for n in nodes do
		(
			selectMore n
		)
		updateSelection()
		addCallback()
	)
	
	on btnClose pressed  do DestroyDialog nw4fForceKeyRollout
)-- Set Force Export Key rollout

rcMenu nw4fNodeUserDataMenu
(
	subMenu "Help" 
	(
		menuItem mi_Help "Help On Set User Data..."
	)
	on mi_Help picked do nintendoExportRollout.showHelp @"html\NW4F_SetUserData.html"
)
rollout nw4fNodeUserDataRollout "Set User Data" width:480 --height:290
(
	group "Selected Node"
	(
		label lblNode width:460
		--dotNetControl lv_nodes "System.Windows.Forms.ListView" width:288 height:164
	)
	group "Edit Data"
	(
		button btnUp "Move Up" across:5
		button btnDown "Move Down" 
		button btnAdd "Add..."
		button btnDelete "Delete"
		button btnEdit "Edit..."
		dotNetControl lv_data "System.Windows.Forms.ListView" width:450 height:164
	)
	checkbox chkDisplayHex "Display integer value in hexadecimals" across:2 align:#left
	button btnClear "Clear Selection" align:#right	
	
	button btnClose "Close" width:474 height:24
		
	local utils = NintendoExportUtilities()
	local donotRedraw
	local nodes = #()
	local dataset = undefined
	
	fn getNodeAttribute n create =
	(
		local attrib = n.custAttributes["NW4F Node Custom Attribute"]
		if attrib == undefined then
		(
			if not create do return undefined
			attrib = nw4f_node_custom_attribute()
			append n.custAttributes attrib
		)
		return attrib
	)
	
	fn initListView =
	(
		lv_data.gridLines = true
		lv_data.View = (dotNetClass "System.Windows.Forms.View").Details
		lv_data.fullRowSelect = true
		lv_data.AutoSize = true
		lv_data.MultiSelect = true
		lv_data.HideSelection = false
		lv_data.Columns.add " Name     "
		lv_data.Columns.add " Node                         "
		lv_data.Columns.add " Type      "
		lv_data.Columns.add " Size"
		lv_data.Columns.add " Value"
		--lv_data.sorting = (dotNetClass "System.Windows.Forms.SortOrder").Ascending
		lv_data.AutoResizeColumns ((dotNetClass "System.Windows.Forms.ColumnHeaderAutoResizeStyle").HeaderSize)
	)
	
	fn saveData =
	(
		-- 1IꂽƂ
		if nodes.count != 1 do return()
		
		local n = nodes[1]
		local attr = getNodeAttribute n true
		if attr != undefined do
		(
			attr.userSettings = dataset.toString()
		)
	)
	
	fn updateButtons = 
	(
		btnAdd.enabled  = true
		if lv_data.SelectedIndices.Count == 0 then
		(
			btnUp.enabled = false
			btnDown.enabled  = false
			btnDelete.enabled  = false
			btnEdit.enabled  = false
			btnClear.enabled = false
		)
		else
		(
			btnDelete.enabled  = true
			btnClear.enabled = true
			btnUp.enabled = btnDown.enabled  = (nodes.count == 1 and dataset.Count() > 1)
			btnEdit.enabled  = lv_data.SelectedIndices.Count == 1
		)
	)
	
	fn updateSelection =
	(
		if donotRedraw do return()
		lv_data.Items.Clear()
		dataset = nw4f_userDataSet()
		
		local lvItems =#()
		
		-- 1IꂽƂ
/*		if nodes.count == 1 then
		(
			lblNode.text = nodes[1].name
			btnUp.enabled = true
			btnDown.enabled  = true
			btnAdd.enabled  = true
			btnDelete.enabled  = true
			btnEdit.enabled  = true
		)
		else
*/
		if nodes.count == 0 then
		(
			lblNode.text = ""
			btnUp.enabled = false
			btnDown.enabled  = false
			btnAdd.enabled  = false
			btnDelete.enabled  = false
			btnEdit.enabled  = false
			return ()
		)
		
		local selnodetext = ""
		
		for n in nodes do
		(
			selnodetext += if (selnodetext=="") then "" else ", "
			selnodetext += n.name
			--local n = nodes[1]
			local attr = getNodeAttribute n false
			if attr != undefined then --Agr[gꍇ
			(
				local str = attr.userSettings
				if (classof str) == String do
				(
					local curdataset = nw4f_userDataSet()
					local ret = curdataset.fromString str
					if ret do
					(
						for d in curdataset.list do
						(
							dataset.appendDataUnique d n
						)
					)
				)
			)
			else -- Agr[gȂꍇ
			(
			)
		)

		lblNode.text = selnodetext
		updateButtons()
		
		for data in dataset.list do
		(
			--local data = dataset.list[i]
			local li = dotNetObject "System.Windows.Forms.ListViewItem" data.dataname
			local sub_li 
			local nodestr = ""
			for n in data.nodes do (
				nodestr += if (nodestr=="") then "" else ", "
				nodestr += n.name
			)
			--print nodestr
			sub_li = li.SubItems.add nodestr
			/*
			local trgStr = ""
			trgStr  = if data.model then
			(
					if data.anim then "M,A"
						else "M"
			)
			else 
			(
				if data.anim then "A"
					else ""
			)
			
			sub_li = li.SubItems.add trgStr
			*/
			sub_li = li.SubItems.add (data.type as String)
			sub_li = li.SubItems.add ((data.valueCount()) as string)
			sub_li = li.SubItems.add ((data.valueToString oneline:true inHex:utils.displayIntegerInHex) as string)
			append lvItems li
		)
		lv_data.Items.AddRange lvItems 
	)
	
	fn addCallback = 
	(
		callbacks.addScript #selectionSetChanged "nw4fNodeUserDataRollout.selectionCallback()" \
			id:#nw4fNodeUserDataSelectionChange
	)
	fn removeCallback = 
	(
		callbacks.removeScripts id:#nw4fNodeUserDataSelectionChange
	)
	fn selectionCallback = 
	(
		nodes = #()
		for n in selection do appendIfUnique nodes n
		updateSelection()
	)
	
	fn EditData data add = 
	(
		nw4fEditUserDataRollout_ValueSet = dataset
		nw4fEditUserDataRollout_Value = data
		nw4fEditUserDataRollout_ValueIniInHex = utils.displayIntegerInHex
		local orgname = data.dataname		
		CreateDialog  nw4fEditUserDataRollout modal:true
		if nw4fEditUserDataRollout_Value != undefined do
		(
			--if add do dataset.appendData nw4fEditUserDataRollout_Value
			--saveData()
			local data = nw4fEditUserDataRollout_Value
			for n in data.nodes do
			(
				--print n.name
				local attr = getNodeAttribute n true
				if attr != undefined then --Agr[gꍇ
				(
					local str = attr.userSettings
					if (classof str) == String do
					(
						local nodedataset = nw4f_userDataSet()
						local ret = nodedataset.fromString str
						--print nodedataset
						--print attr.userSettings
						if add then
						(
							nodedataset.appendData nw4fEditUserDataRollout_Value
						)
						else
						(
							for i = 1 to nodedataset.list.count while ret do
							(
								local nodedata = nodedataset.list[i]
								if (orgname == nodedata.dataname) do
								(
									nodedataset.list[i] = (copy data)
									ret = false
								)
							)
						)
						attr.userSettings = nodedataset.toString()
						--print nodedataset
						--print attr.userSettings
					)
				)
			)
			updateSelection()
		)
	)
	
	on nw4fNodeUserDataRollout open  do
	(
		donotRedraw = false
		initListView()
		utils.loadSettingConfig()
		chkDisplayHex.checked = utils.displayIntegerInHex
		nodes = #()
		addCallback()
		selectionCallback()
	)
	on nw4fNodeUserDataRollout close  do
	(
		removeCallback()
	)
	
	on lv_data SelectedIndexChanged e do
	(
		updateButtons()
	)
	
	on lv_data DoubleClick e do
	(
		if (classof dataset) == nw4f_userDataSet do
		(
			if lv_data.SelectedIndices.Count == 1 then
			(
				local id = lv_data.SelectedIndices.Item[0]
				local maxid = id + 1
				editData (dataset.list[maxid]) false
			)
			else
			(
				messageBox "Please select one user data."
			)
		)
	)
	
	on chkDisplayHex changed val do
	(
		utils.displayIntegerInHex = val
		utils.saveSettingConfig()
		updateSelection()
	)
	
	on btnUp pressed do 
	(
		if lv_data.SelectedIndices.Count > 0 do
		(
			local newSel = #()
			for i = 0 to (lv_data.SelectedIndices.Count - 1) do
			(
				local id = lv_data.SelectedIndices.Item[i]
				local maxid = id + 1
				if id > 0  and \
					 (findItem newSel (id - 1)) == 0 then
				(
					local tmp = dataset.list[maxid]
					deleteItem dataset.list (maxid)
					insertItem tmp dataset.list (maxid - 1)
					appendIfUnique newSel (id - 1)
				)
				else
				(
					appendIfUnique newSel id
				)
			)
			saveData()
			updateSelection()
			lv_data.Focus()
			for s in newSel do lv_data.Items.Item[s].Selected = true
		)
	)
	
	on btnDown pressed do 
	(
		if lv_data.SelectedIndices.Count > 0 do
		(
			local newSel = #()
			for i = (lv_data.SelectedIndices.Count - 1) to 0 by -1 do
			(
				local id = lv_data.SelectedIndices.Item[i]
				local maxid = id + 1
				if maxid < dataset.list.count and \
					(findItem newSel (id + 1)) == 0 then
				--if maxid < dataset.list.count then
				(
					local tmp = dataset.list[maxid]
					deleteItem dataset.list (maxid)
					insertItem tmp dataset.list (maxid + 1)
					appendIfUnique newSel (id + 1)
				)
				else
				(
					appendIfUnique newSel id
				)
			)
			saveData()
			updateSelection()
			lv_data.Focus()
			for s in newSel do lv_data.Items.Item[s].Selected = true
		)
	)

	on btnDelete pressed do 
	(
		if lv_data.SelectedIndices.Count > 0 then
		(
			if not (queryBox "Delete selected item?") do return ()
			
			for i = 0 to (lv_data.SelectedIndices.Count - 1) do
			(
				local id = lv_data.SelectedIndices.Item[i]
				local maxid = id + 1
				local dataname = lv_data.Items.Item[id].Text
				--print dataname
				local data = dataset.list[maxid]
				for n in data.nodes do
				(
					--print n.name
					local attr = getNodeAttribute n false
					if attr != undefined then --Agr[gꍇ
					(
						local str = attr.userSettings
						if (classof str) == String do
						(
							local nodedataset = nw4f_userDataSet()
							local ret = nodedataset.fromString str
							--print nodedataset
							for i = 1 to nodedataset.list.count while ret do
							(
								local nodedata = nodedataset.list[i]
								if (data.compare nodedata) do
								(
									deleteItem nodedataset.list i
									attr.userSettings = nodedataset.toString()
									ret = false
								)
							)
							--print nodedataset
						)
					)
				)
			)
			updateSelection()
			lv_data.Focus()
		)
		else
		(
			messageBox "Please select user data."
		)	
	)
	
	on btnAdd pressed do 
	(
		if (classof dataset) == nw4f_userDataSet do
		(
			local newData = nw4f_userData()
			if lv_data.SelectedIndices.Count == 0 then
			(
				newData.nodes = (deepcopy nodes)
			)
			else
			(
				local newNodes =#()
				for i = 0 to (lv_data.SelectedIndices.Count - 1) do
				(
					local id = lv_data.SelectedIndices.Item[i]
					local maxid = id + 1
					local dataname = lv_data.Items.Item[id].Text
					--print dataname
					local data = dataset.list[maxid]
					join newNodes data.nodes
				)
				--print newNodes
				newData.nodes = makeUniqueArray newNodes
			)
			editData newData true
		)
	)
	
	on btnEdit pressed do 
	(
		if (classof dataset) == nw4f_userDataSet do
		(
			if lv_data.SelectedIndices.Count == 1 then
			(
				local id = lv_data.SelectedIndices.Item[0]
				local maxid = id + 1
				editData (dataset.list[maxid]) false
			)
			else
			(
				messageBox "Please select one user data."
			)
		)
	)
	
	on btnClear pressed  do
	(
		lv_data.SelectedIndices.Clear()
	)
	
	on btnClose pressed  do DestroyDialog nw4fNodeUserDataRollout
		
)-- Set User Data

