﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <nn/nn_Macro.h>
#include <nn/vi.h>
#include <nvn/nvn.h>
#include <nvn/nvn_FuncPtrInline.h>
#include "Window.h"

class Graphics
{
public:
    Graphics() NN_NOEXCEPT;
    ~Graphics() NN_NOEXCEPT;

    void Update() NN_NOEXCEPT;

    void RegisterLayer(nn::vi::Layer* pLayer, int width, int height, Color backgroundColor) NN_NOEXCEPT;
private:
    NVNdevice m_Device;
    NVNqueue m_Queue;
    NVNcommandBuffer m_CommandBuffer;
    NVNsync m_CommandSync;

    MemoryPool m_Pool;

    // TODO: find a real size
    static const size_t ControlMemoryAlignedSize = 512;
    void* m_ControlMemory;

    typedef std::vector<Window*> WindowList;
    WindowList m_Windows;
};
