﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt.h>
#include <vector>
#include <nn/nn_Macro.h>

namespace nnt { namespace settings {
    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;

    void Write(const void* buffer, size_t bufferSize, const char* key) NN_NOEXCEPT;

    template <typename T>
    void WriteValue(T value, const char* key) NN_NOEXCEPT
    {
        Write(&value, sizeof(T), key);
    }

    template <typename T, size_t Size>
    void WriteBuffer(const T (&buffer)[Size], const char* key) NN_NOEXCEPT
    {
        Write(buffer, Size, key);
    }
}}
