﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nnt.h>
#include <nn/nn_Macro.h>

class MemoryFixtureImpl;

class MemoryFixture : public ::testing::Test
{
public:
    MemoryFixture() NN_NOEXCEPT;
    ~MemoryFixture() NN_NOEXCEPT;

    virtual void SetUp() NN_NOEXCEPT NN_OVERRIDE;
    virtual void TearDown() NN_NOEXCEPT NN_OVERRIDE;

    void CheckLeaks() NN_NOEXCEPT;
private:
    std::unique_ptr<MemoryFixtureImpl> m_Impl;
};
