﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.private.h>

typedef nnt::vi::util::Fixture SetDisplayMagnification;

TEST_F(SetDisplayMagnification, Default_NegativeX_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, -1, 0, 100, 100));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, External_NegativeX_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, -1, 0, 100, 100));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, Default_NegativeY_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, 0, -1, 100, 100));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, External_NegativeY_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, 0, -1, 100, 100));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, Default_PastLogicalResolutionWidth_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    int width;
    int height;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));
    EXPECT_EQ(1920, width);
    EXPECT_EQ(1080, height);

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, width + 1, 0, width + 2, height));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, External_PastLogicalResolutionWidth_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    int width;
    int height;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));
    EXPECT_EQ(1920, width);
    EXPECT_EQ(1080, height);

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, width + 1, 0, width + 2, height));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, Default_PastLogicalResolutionHeight_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    int width;
    int height;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));
    EXPECT_EQ(1920, width);
    EXPECT_EQ(1080, height);

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, 0, height + 1, width, height + 2));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, External_PastLogicalResolutionHeight_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    int width;
    int height;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));
    EXPECT_EQ(1920, width);
    EXPECT_EQ(1080, height);

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, 0, height + 1, width, height + 2));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, Default_NegativeWidth_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, 0, 0, -1, 100));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, External_NegativeWidth_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, 0, 0, -1, 100));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, Default_NegativeHeight_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, 0, 0, 100, -1));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, External_NegativeHeight_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, 0, 0, 100, -1));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, Default_WidthPastLogicalResolution_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    int width;
    int height;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));
    EXPECT_EQ(1920, width);
    EXPECT_EQ(1080, height);

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, 0, 0, width + 1, height));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, External_WidthPastLogicalResolution_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    int width;
    int height;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));
    EXPECT_EQ(1920, width);
    EXPECT_EQ(1080, height);

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, 0, 0, width + 1, height));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, Default_HeightPastLogicalResolution_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    int width;
    int height;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));
    EXPECT_EQ(1920, width);
    EXPECT_EQ(1080, height);

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, 0, 0, width, height + 1));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, External_HeightPastLogicalResolution_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    int width;
    int height;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));
    EXPECT_EQ(1920, width);
    EXPECT_EQ(1080, height);

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, 0, 0, width, height + 1));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, Default_ViewportPastLogicalWidth_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    int width;
    int height;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));
    EXPECT_EQ(1920, width);
    EXPECT_EQ(1080, height);

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, 1, 0, width + 1, height));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, External_ViewportPastLogicalWidth_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    int width;
    int height;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));
    EXPECT_EQ(1920, width);
    EXPECT_EQ(1080, height);

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, 1, 0, width + 1, height));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, Default_ViewportPastLogicalHeight_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    int width;
    int height;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));
    EXPECT_EQ(1920, width);
    EXPECT_EQ(1080, height);

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, 0, 1, width, height + 1));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, External_ViewportPastLogicalHeight_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    int width;
    int height;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));
    EXPECT_EQ(1920, width);
    EXPECT_EQ(1080, height);

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultInvalidDimensions, nn::vi::SetDisplayMagnification(pDisplay, 0, 1, width, height + 1));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, Default_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    int width;
    int height;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));
    EXPECT_EQ(1920, width);
    EXPECT_EQ(1080, height);

    const int ViewportWidth = 1280;
    const int ViewportHeight = 720;

    for( int x = 0; x + ViewportWidth <= width; ++x )
    {
        NNT_EXPECT_RESULT_SUCCESS(nn::vi::SetDisplayMagnification(pDisplay, x, 0, ViewportWidth, ViewportHeight));
    }

    for( int x = 0; x + ViewportWidth <= width; ++x )
    {
        NNT_EXPECT_RESULT_SUCCESS(nn::vi::SetDisplayMagnification(pDisplay, x, height - ViewportHeight, ViewportWidth, ViewportHeight));
    }

    for( int y = 0; y + ViewportHeight <= height; ++y )
    {
        NNT_EXPECT_RESULT_SUCCESS(nn::vi::SetDisplayMagnification(pDisplay, 0, y, ViewportWidth, ViewportHeight));
    }

    for( int y = 0; y + ViewportHeight <= height; ++y )
    {
        NNT_EXPECT_RESULT_SUCCESS(nn::vi::SetDisplayMagnification(pDisplay, width - ViewportWidth, y, ViewportWidth, ViewportHeight));
    }

    NNT_EXPECT_RESULT_SUCCESS(nn::vi::SetDisplayMagnification(pDisplay, 0, 0, 1, 1));
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::SetDisplayMagnification(pDisplay, 0, 0, width, height));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, External_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    int width;
    int height;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayLogicalResolution(&width, &height, pDisplay));
    EXPECT_EQ(1920, width);
    EXPECT_EQ(1080, height);

    const int ViewportWidth = 1280;
    const int ViewportHeight = 720;

    for( int x = 0; x + ViewportWidth <= width; ++x )
    {
        NNT_EXPECT_RESULT_SUCCESS(nn::vi::SetDisplayMagnification(pDisplay, x, 0, ViewportWidth, ViewportHeight));
    }

    for( int x = 0; x + ViewportWidth <= width; ++x )
    {
        NNT_EXPECT_RESULT_SUCCESS(nn::vi::SetDisplayMagnification(pDisplay, x, height - ViewportHeight, ViewportWidth, ViewportHeight));
    }

    for( int y = 0; y + ViewportHeight <= height; ++y )
    {
        NNT_EXPECT_RESULT_SUCCESS(nn::vi::SetDisplayMagnification(pDisplay, 0, y, ViewportWidth, ViewportHeight));
    }

    for( int y = 0; y + ViewportHeight <= height; ++y )
    {
        NNT_EXPECT_RESULT_SUCCESS(nn::vi::SetDisplayMagnification(pDisplay, width - ViewportWidth, y, ViewportWidth, ViewportHeight));
    }

    NNT_EXPECT_RESULT_SUCCESS(nn::vi::SetDisplayMagnification(pDisplay, 0, 0, 1, 1));
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::SetDisplayMagnification(pDisplay, 0, 0, width, height));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(SetDisplayMagnification, Edid_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Edid"));

    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultNotSupported, nn::vi::SetDisplayMagnification(pDisplay, 0, 0, 100, 100));
}

TEST(SetDisplayMagnificationPreconditions, ViNotInitialized_Any)
{
    nn::vi::Display* pDisplay = reinterpret_cast<nn::vi::Display*>(0x1234);
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::SetDisplayMagnification(pDisplay, 0, 0, 100, 100), "");
}

TEST(SetDisplayMagnificationPreconditions, pDisplayNull_Any)
{
    nn::vi::Initialize();

    EXPECT_DEATH_IF_SUPPORTED(nn::vi::SetDisplayMagnification(nullptr, 0, 0, 100, 100), "");

    nn::vi::Finalize();
}

TEST(SetDisplayMagnificationPreconditions, pDisplayInvalidHandle_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        nn::vi::CloseDisplay(pDisplay);

        EXPECT_DEATH_IF_SUPPORTED(nn::vi::SetDisplayMagnification(pDisplay, 0, 0, 100, 100), "");
    }

    nn::vi::Finalize();
}
