﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.private.h>

typedef nnt::vi::util::Fixture GetZOrderCountMax;

TEST_F(GetZOrderCountMax, Default_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    EXPECT_EQ(255, nn::vi::GetZOrderCountMax(pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(GetZOrderCountMax, External_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    EXPECT_EQ(0, nn::vi::GetZOrderCountMax(pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(GetZOrderCountMax, Edid_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Edid"));

    EXPECT_EQ(0, nn::vi::GetZOrderCountMax(pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}

TEST(GetZOrderCountMaxPreconditions, ViNotInitialized_Any)
{
    nn::vi::Display* pDisplay = reinterpret_cast<nn::vi::Display*>(0x1234);

    ASSERT_DEATH_IF_SUPPORTED(nn::vi::GetZOrderCountMax(pDisplay), "");
}

TEST(GetZOrderCountMaxPreconditions, pDisplayNull_Any)
{
    nn::vi::Initialize();

    ASSERT_DEATH_IF_SUPPORTED(nn::vi::GetZOrderCountMax(nullptr), "");

    nn::vi::Finalize();
}

TEST(GetZOrderCountMaxPreconditions, pDisplayInvalidHandle_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        nn::vi::CloseDisplay(pDisplay);
        EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetZOrderCountMax(pDisplay), "");
    }

    nn::vi::Finalize();
}
