﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.private.h>

typedef nnt::vi::util::Fixture GetDisplayResolution;

TEST_F(GetDisplayResolution, Default_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    int width = 0;
    int height = 0;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayResolution(&width, &height, pDisplay));
    EXPECT_GT(width, 0);
    EXPECT_GT(height, 0);

    nn::vi::CloseDisplay(pDisplay);
}

TEST(GetDisplayResolutionPreconditions, ViNotInitialized_Any)
{
    // need some non-null value
    nn::vi::Display* pDisplay = reinterpret_cast<nn::vi::Display*>(0x1234);
    int width;
    int height;

    ASSERT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayResolution(&width, &height, pDisplay), "");
}

TEST(GetDisplayResolutionPreconditions, pOutWidthNull_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        int height;
        EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayResolution(nullptr, &height, pDisplay), "");

        nn::vi::CloseDisplay(pDisplay);
    }

    nn::vi::Finalize();
}

TEST(GetDisplayResolutionPreconditions, pOutHeightNull_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        int width;
        EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayResolution(&width, nullptr, pDisplay), "");

        nn::vi::CloseDisplay(pDisplay);
    }

    nn::vi::Finalize();
}

TEST(GetDisplayResolutionPreconditions, pDisplayNull_Any)
{
    nn::vi::Initialize();

    int width;
    int height;
    EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayResolution(&width, &height, nullptr), "");

    nn::vi::Finalize();
}

TEST(GetDisplayResolutionPreconditions, pDisplayInvalidHandle_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        nn::vi::CloseDisplay(pDisplay);

        int width;
        int height;
        EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayResolution(&width, &height, pDisplay), "");
    }

    nn::vi::Finalize();
}
