﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.private.h>
#include <nn/ae.h>

typedef nnt::vi::util::Fixture GetDisplayMode;

TEST_F(GetDisplayMode, Default_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    nn::vi::DisplayModeInfo mode{ 0, 0, 0.f, nn::vi::StereoMode_None };
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayMode(&mode, pDisplay));

    EXPECT_NE(0, mode.width);
    EXPECT_NE(0, mode.height);
    EXPECT_NEAR(60.f, mode.refreshRate, .001f);
    EXPECT_EQ(nn::vi::StereoMode_None, mode.mode);

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(GetDisplayMode, External_Console_IcosaCopper)
{
    if( nn::ae::GetOperationMode() == nn::ae::OperationMode_Console )
    {
        nn::vi::Initialize();

        nn::vi::Display* pDisplay;
        NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

        nn::vi::DisplayModeInfo mode{ 0, 0, 0.f, nn::vi::StereoMode_None };
        NNT_ASSERT_RESULT_SUCCESS(nn::vi::GetDisplayMode(&mode, pDisplay));

        EXPECT_NE(0, mode.width);
        EXPECT_NE(0, mode.height);
        EXPECT_NEAR(60.f, mode.refreshRate, .001f);
        EXPECT_EQ(nn::vi::StereoMode_None, mode.mode);

        nn::vi::CloseDisplay(pDisplay);
    }
}

TEST_F(GetDisplayMode, External_Handheld_IcosaCopper)
{
    if( nn::ae::GetOperationMode() == nn::ae::OperationMode_Handheld )
    {
        nn::vi::Initialize();

        nn::vi::Display* pDisplay;
        NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

        nn::vi::DisplayModeInfo mode;
        NNT_ASSERT_RESULT_FAILURE(nn::vi::ResultDisplayDisconnected, nn::vi::GetDisplayMode(&mode, pDisplay));

        nn::vi::CloseDisplay(pDisplay);
    }
}

TEST_F(GetDisplayMode, Edid_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Edid"));

    nn::vi::DisplayModeInfo mode;
    NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultOperationFailed, nn::vi::GetDisplayMode(&mode, pDisplay));

    nn::vi::CloseDisplay(pDisplay);
}

TEST(GetDisplayModePreconditions, ViNotInitialized_Any)
{
    nn::vi::Display* pDisplay = reinterpret_cast<nn::vi::Display*>(0x1234);

    nn::vi::DisplayModeInfo mode;
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayMode(&mode, pDisplay), "");
}

TEST(GetDisplayModePreconditions, pOutModeNull_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayMode(nullptr, pDisplay), "");

        nn::vi::CloseDisplay(pDisplay);
    }

    nn::vi::Finalize();
}

TEST(GetDisplayModePreconditions, pDisplayNull_Any)
{
    nn::vi::Initialize();

    nn::vi::DisplayModeInfo mode;
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayMode(&mode, nullptr), "");

    nn::vi::Finalize();
}

TEST(GetDisplayModePreconditions, pDisplayInvalidHandle_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay = nullptr;
    NNT_EXPECT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    if( pDisplay != nullptr )
    {
        nn::vi::CloseDisplay(pDisplay);

        nn::vi::DisplayModeInfo mode;
        EXPECT_DEATH_IF_SUPPORTED(nn::vi::GetDisplayMode(&mode, pDisplay), "");
    }

    nn::vi::Finalize();
}
