﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.private.h>

typedef nnt::vi::util::Fixture CreateLayer;

TEST_F(CreateLayer, External_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "External"));

    nn::vi::Layer* pLayer;
    // TODO: the wrong result is returned in these cases
    //NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultDenied, nn::vi::CreateLayer(&pLayer, pDisplay));
    //NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultDenied, nn::vi::CreateLayer(&pLayer, pDisplay, nn::vi::LayerSettings()));
    EXPECT_TRUE(nn::vi::CreateLayer(&pLayer, pDisplay).IsFailure());
    EXPECT_TRUE(nn::vi::CreateLayer(&pLayer, pDisplay, nn::vi::LayerSettings()).IsFailure());

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(CreateLayer, Edid_IcosaCopper)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDisplay(&pDisplay, "Edid"));

    nn::vi::Layer* pLayer;
    // TODO: the wrong result is returned in these cases
    //NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultDenied, nn::vi::CreateLayer(&pLayer, pDisplay));
    //NNT_EXPECT_RESULT_FAILURE(nn::vi::ResultDenied, nn::vi::CreateLayer(&pLayer, pDisplay, nn::vi::LayerSettings()));
    EXPECT_TRUE(nn::vi::CreateLayer(&pLayer, pDisplay).IsFailure());
    EXPECT_TRUE(nn::vi::CreateLayer(&pLayer, pDisplay, nn::vi::LayerSettings()).IsFailure());

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(CreateLayer, NoSettings_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    nn::vi::Layer* pLayer;
    nn::vi::LayerSettings settings;
    settings.Reset();
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::CreateLayer(&pLayer, pDisplay, settings));

    nn::vi::DestroyLayer(pLayer);
    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(CreateLayer, Fullscreen_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    nn::vi::Layer* pLayer;
    nn::vi::LayerSettings settings;
    settings.Reset();
    settings.Set<nn::vi::LayerFlags::Fullscreen>();
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::CreateLayer(&pLayer, pDisplay, settings));

    nn::vi::DestroyLayer(pLayer);
    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(CreateLayer, Opaque_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    nn::vi::Layer* pLayer;
    nn::vi::LayerSettings settings;
    settings.Reset();
    settings.Set<nn::vi::LayerFlags::Opaque>();
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::CreateLayer(&pLayer, pDisplay, settings));

    nn::vi::DestroyLayer(pLayer);
    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(CreateLayer, FullscreenAndOpaque_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

    nn::vi::Layer* pLayer;
    nn::vi::LayerSettings settings;
    settings.Reset();
    settings.Set<nn::vi::LayerFlags::Fullscreen>();
    settings.Set<nn::vi::LayerFlags::Opaque>();
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::CreateLayer(&pLayer, pDisplay, settings));

    nn::vi::DestroyLayer(pLayer);
    nn::vi::CloseDisplay(pDisplay);
}
