﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.h>

typedef nnt::vi::util::Fixture OpenDefaultDisplay;

TEST_F(OpenDefaultDisplay, Success_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));
    EXPECT_NE(nullptr, pDisplay);

    nn::vi::CloseDisplay(pDisplay);
}

TEST_F(OpenDefaultDisplay, DoubleOpen_Any)
{
    nn::vi::Initialize();

    nn::vi::Display* pDisplay;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));
    EXPECT_NE(nullptr, pDisplay);

    nn::vi::Display* pDupe;
    NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDupe));
    EXPECT_EQ(pDisplay, pDupe);

    nn::vi::CloseDisplay(pDisplay);
    nn::vi::CloseDisplay(pDisplay);
}

TEST(OpenDefaultDisplayPreconditions, ViNotInitialized_Any)
{
    nn::vi::Display* pDisplay;
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::OpenDefaultDisplay(&pDisplay), "");
}

TEST(OpenDefaultDisplayPreconditions, pOutDisplayNull_Any)
{
    nn::vi::Initialize();
    EXPECT_DEATH_IF_SUPPORTED(nn::vi::OpenDefaultDisplay(nullptr), "");
    nn::vi::Finalize();
}
