﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "IPanelPreparationTask.h"
#include "PanelText.h"
#include "../framework/Rectangle.h"

namespace panel
{
    class PanelTextPreparationTask
        : public IPanelPreparationTask
    {
    public:
        PanelTextPreparationTask(
            const std::shared_ptr<PanelText>& pPanel,
            float positionX,
            float positionY,
            float viewportWidth,
            float viewportHeight,
            float fontSize,
            const nn::util::Color4f& fontColor,
            const std::string& text
        );

        virtual PanelPreparationResult Prepare(nn::gfx::CommandBuffer* pCommandBuffer, int resourceLockIndex) NN_NOEXCEPT NN_OVERRIDE;
    private:
        std::weak_ptr<PanelText> m_pPanel;
        float m_PositionX;
        float m_PositionY;
        float m_ViewportWidth;
        float m_ViewportHeight;
        float m_FontSize;
        nn::util::Color4f m_FontColor;
        std::string m_Text;
    };

}
