﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "IPanelPreparationTask.h"
#include "PanelImage.h"
#include "../framework/ImageTransferBuffer.h"

namespace panel
{
    class PanelImagePreparationTask
        : public IPanelPreparationTask
    {
    public:
        PanelImagePreparationTask(
            const std::shared_ptr<PanelImage>& pPanel,
            const std::shared_ptr<ImageTransferBuffer>& pBuffer
        );

        virtual PanelPreparationResult Prepare(nn::gfx::CommandBuffer* pCommandBuffer, int resourceLockIndex) NN_NOEXCEPT NN_OVERRIDE;
    private:
        std::weak_ptr<PanelImage> m_pPanel;
        std::weak_ptr<ImageTransferBuffer> m_pBuffer;
    };

}
