﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "PanelImage.h"
#include "PanelImagePreparationTask.h"

#include "../framework/Framework.h"

PanelImage::PanelImage()
    : PanelBase(PanelType_Image)
{
}

void PanelImage::SetTransferBuffer(const std::shared_ptr<ImageTransferBuffer>& value) NN_NOEXCEPT
{
    m_pTransferBuffer = value;
}

std::shared_ptr<ImageTransferBuffer> PanelImage::GetTransferBuffer() NN_NOEXCEPT
{
    return m_pTransferBuffer;
}

void PanelImage::Update() NN_NOEXCEPT
{
    auto pTask = std::make_shared<panel::PanelImagePreparationTask>(
        this->shared_from_this(),
        m_pTransferBuffer
    );
    Framework::GetPanelPreparationTaskQueue()->Enqueue(pTask);
}

void PanelImage::SetTexture(const std::shared_ptr<framework::PoolTexture>& value) NN_NOEXCEPT
{
    m_pTexture = value;
}

std::shared_ptr<framework::PoolTexture> PanelImage::GetTexture() NN_NOEXCEPT
{
    return m_pTexture;
}
