﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "../gfx_GraphicsFramework.h"
#include "../FrameworkParameter.h"

namespace framework{ namespace detail{

    class MemoryPoolHolder
    {
    public:
        MemoryPoolHolder() NN_NOEXCEPT;

        void Initialize(nns::gfx::GraphicsFramework::MemoryPoolType poolType, size_t poolSize) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        void UpdateAllocatedSize() NN_NOEXCEPT;
        ptrdiff_t Allocate(size_t size, size_t alignment) NN_NOEXCEPT;
        void Free(ptrdiff_t offset) NN_NOEXCEPT;
        nn::gfx::MemoryPool* GetPool() NN_NOEXCEPT;
        size_t GetTotalAllocatedSize() const NN_NOEXCEPT;
        size_t GetTotalAllocatedSizeMax() const NN_NOEXCEPT;
    private:
        nns::gfx::GraphicsFramework::MemoryPoolType m_PoolType;
        size_t m_PoolSize;
        size_t m_TotalAllocatedSize;
        size_t m_TotalAllocatedSizeMax;
    };

    class MemoryPoolManager
    {
    public:
        void Initialize(const FrameworkMemoryPoolParameter& param) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        MemoryPoolHolder* GetTextureMemoryPoolHolder() NN_NOEXCEPT;
        MemoryPoolHolder* GetCommandBufferMemoryPoolHolder() NN_NOEXCEPT;
        MemoryPoolHolder* GetConstantBufferMemoryPoolHolder() NN_NOEXCEPT;
        MemoryPoolHolder* GetShaderMemoryPoolHolder() NN_NOEXCEPT;
        MemoryPoolHolder* GetDataMemoryPoolHolder() NN_NOEXCEPT;

    private:
        MemoryPoolHolder m_TextureMemoryPoolHolder;
        MemoryPoolHolder m_CommandBufferMemoryPoolHolder;
        MemoryPoolHolder m_ConstantBufferMemoryPoolHolder;
        MemoryPoolHolder m_ShaderMemoryPoolHolder;
        MemoryPoolHolder m_DataMemoryPoolHolder;
    };

}}
