﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "DisplayModule.h"

#include <nn/nn_Abort.h>


#if defined(NNT_VI_FW_DISPLAY_SYSTEM_INDIRECT_TESTSERVER)

#include <nn/os.h>
#include <nn/vi/vi_IndirectProducer.private.h>

#include <nnt/vi/testVi_TestServerProxy.h>
#include "../../../Programs/Eris/Sources/Libraries/vi/dev/vi_ExternalLayer.h"

namespace framework{ namespace detail{

    nnt::vi::TestServiceProxy g_DisplayTestProxy;

    nn::vi::IndirectProducerHandleType g_hDisplayIndirectProducer;
    nn::vi::IndirectLayer* g_pDisplayIndirectLayer;
    nn::vi::Layer* g_pDisplayLayer;

    nn::os::ThreadType g_FlipWorkerThread;
    NN_ALIGNAS(4096) char g_FlipWorkerThreadStack[16 * 1024];

    namespace {
        void FlipWorker(void*) NN_NOEXCEPT
        {
            nn::os::TimerEventType timerEvent;
            nn::os::InitializeTimerEvent(&timerEvent, nn::os::EventClearMode_ManualClear);

            nn::TimeSpan interval = nn::TimeSpan::FromMilliSeconds(16);
            nn::os::StartPeriodicTimerEvent(&timerEvent, interval, interval);

            for(;;)
            {
                nn::os::WaitTimerEvent(&timerEvent);
                nn::os::ClearTimerEvent(&timerEvent);

                nn::vi::FlipIndirectLayer(g_pDisplayIndirectLayer);
            }
        }
    }

    void DisplayModule::Initialize() NN_NOEXCEPT
    {
        // テスト用サーバで IndirectLayer を作って IndirectLayerProducerHandle を取得。
        {
            int32_t LayerSlot = 0;
            NN_ABORT_UNLESS_RESULT_SUCCESS(g_DisplayTestProxy.Initialize());
            g_DisplayTestProxy.GetService()->CreateIndirectLayer(LayerSlot);
            g_DisplayTestProxy.GetService()->DestroyIndirectLayerProducerEndPoint(LayerSlot);
            NN_ABORT_UNLESS_RESULT_SUCCESS(g_DisplayTestProxy.GetService()->CreateIndirectLayerProducerEndPoint(
                &g_hDisplayIndirectProducer, LayerSlot, nn::applet::GetAppletResourceUserId()
            ));
        }

        // vi を初期化してレイヤを取得
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS(nn::vi::InitializeForIndirectProducer());
            NN_ABORT_UNLESS_RESULT_SUCCESS(nn::vi::OpenIndirectLayer(&g_pDisplayIndirectLayer, g_hDisplayIndirectProducer));

            nn::vi::NativeWindowHandle hNativeWindow = nullptr;
            NN_ABORT_UNLESS_RESULT_SUCCESS(nn::vi::GetIndirectLayerNativeWindow(&hNativeWindow, g_pDisplayIndirectLayer));

            // TORIAEZU:
            // nn::gfx のために nn::vi::Layer として見せる
            nn::vi::dev::g_ExternalNativeWindowList[0] = hNativeWindow;
            g_pDisplayLayer = reinterpret_cast<nn::vi::Layer*>(&nn::vi::dev::g_ExternalNativeWindowList[0]);
        }

        // 今回はメンバ変数使わない。
        m_pDisplay = nullptr;
        m_pLayer = nullptr;

        // flip worker を起動
        nn::os::CreateThread(&g_FlipWorkerThread, FlipWorker, nullptr, g_FlipWorkerThreadStack, sizeof(g_FlipWorkerThreadStack), nn::os::DefaultThreadPriority);
        nn::os::StartThread(&g_FlipWorkerThread);
    }

    void DisplayModule::Finalize() NN_NOEXCEPT
    {
        nn::vi::FinalizeForIndirectProducer();
        g_DisplayTestProxy.Finalize();
    }

    nn::vi::Layer* DisplayModule::GetLayer() NN_NOEXCEPT
    {
        return g_pDisplayLayer;
    }

}}


#else
// 通常の VI 初期化

namespace framework{ namespace detail{
    void DisplayModule::Initialize() NN_NOEXCEPT
    {
        nn::vi::Initialize();
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&m_pDisplay));
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::vi::CreateLayer(&m_pLayer, m_pDisplay));
    }

    void DisplayModule::Finalize() NN_NOEXCEPT
    {
        nn::vi::DestroyLayer(m_pLayer);
        nn::vi::CloseDisplay(m_pDisplay);
        nn::vi::Finalize();
        m_pLayer = nullptr;
        m_pDisplay = nullptr;
    }

    nn::vi::Layer* DisplayModule::GetLayer() NN_NOEXCEPT
    {
        return m_pLayer;
    }
}}

#endif

namespace framework{ namespace detail{
    DisplayModule g_DisplayModule;
}}
