﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Result.h>
#include <nn/vi/native/vi_NativeType.h>
#include "../../../Programs/Eris/Sources/Libraries/visrv/native/visrv_NativeType.h"

extern "C"{
    typedef enum{
        NvSuccess = 0,
        NvError_Force32 = 0x7FFFFFFF
    } NvError;

    NvError NvRmMemHandleFromFd(int fd, NvRmMemHandle *hMem);
    NvU64 NvRmMemGetSize(NvRmMemHandle hMem);
    void NvRmMemHandleFree(NvRmMemHandle hMem);
}

// sync
extern "C"{
    typedef struct NvRmFenceRec NvRmFence;
    struct syncfd_nvrm_mapping;
    int sync_create_nvrm_mapping(const NvRmFence* fences, unsigned num_fences);
    int sync_close(int fd);
    int sync_wait(int fd, int timeout);
}


namespace nnt{ namespace vi{

    void WaitSync(const nn::vi::native::NativeSync& sync) NN_NOEXCEPT;

}}
