﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <glv.h>
#include <glv_binding.h>

namespace glvapp {

/**
 *  @brief アプリケーションフレームワークのルートサーフェイスコンテキストです。
 */
class RootSurfaceContext : public glv::Window, public glv::GLV, public glv::ApplicationLoopCallback
{
    NN_DISALLOW_COPY( RootSurfaceContext );
    NN_DISALLOW_MOVE( RootSurfaceContext );

public:
    /**
     * @brief       コンストラクタです。
     */
    RootSurfaceContext() NN_NOEXCEPT;

    /**
     * @brief       デストラクタです。
     */
    ~RootSurfaceContext() NN_NOEXCEPT;

    /**
     * @brief       ランタイムエンジンにアタッチされた際に呼ばれます。
     *
     * @param[in]   context     コンテキスト
     *
     * @see         glv::ApplicationLoopCallback::OnLoopAttached()
     */
    virtual void OnLoopAttached(glv::ApplicationLoopContext& context) NN_NOEXCEPT NN_OVERRIDE;

    /**
     * @brief       ランタイムエンジンからデタッチされた際に呼ばれます。
     *
     * @param[in]   context     コンテキスト
     *
     * @see         glv::ApplicationLoopCallback::OnLoopDetached()
     */
    virtual void OnLoopDetached(glv::ApplicationLoopContext& context) NN_NOEXCEPT NN_OVERRIDE;

    /**
     * @brief       glv シーンレンダラ前に呼ばれます。
     *
     * @param[in]   context     コンテキスト
     * @param[in]   events      イベント
     *
     * @details     glv シーンレンダラへ hid 系イベントが通知される前に呼び出されます。
     *              この時点ではまだ glv コンテキストのレンダリングは開始していません。
     *              このメソッドが呼び出されるフレームは OnLoopAfterSceneRenderer() と同じです。
     *
     * @return      現在は RequiredRestoration::RequireRestrationNothing を返すようにしてください。
     *
     * @see         glv::ApplicationLoopCallback::OnLoopBeforeSceneRenderer()
     */
    virtual const glv::RequiredRestoration OnLoopBeforeSceneRenderer(glv::ApplicationLoopContext& context, const glv::HidEvents& events) NN_NOEXCEPT NN_OVERRIDE;

    /**
     * @brief       glv シーンレンダラ後に呼ばれます。
     *
     * @param[in]   context     コンテキスト
     * @param[in]   events      イベント
     *
     * @details     glv シーンレンダラのレンダリングが終わった後に呼び出されます。
     *              このメソッドが呼び出されるフレームは OnLoopBeforeSceneRenderer() と同じです。
     *
     * @return      現在は RequiredRestoration::RequireRestrationNothing を返すようにしてください。
     *
     * @see         glv::ApplicationLoopCallback::OnLoopAfterSceneRenderer()
     */
    virtual const glv::RequiredRestoration OnLoopAfterSceneRenderer(glv::ApplicationLoopContext& context, const glv::HidEvents& events) NN_NOEXCEPT NN_OVERRIDE;

    /**
     * @brief       イベント処理時に呼ばれます。
     *
     * @param[in]   events      イベント
     * @param[in]   context     コンテキスト
     *
     * @return      イベントを処理したら真を返します。
     */
    virtual bool onEvent(glv::Event::t events, glv::GLV& context) NN_NOEXCEPT NN_OVERRIDE;

    /**
     * @brief       描画時に呼ばれます。
     *
     * @param[in]   context     コンテキスト
     */
    virtual void onDraw(glv::GLV& context) NN_NOEXCEPT NN_OVERRIDE;

private:
    glv::Style m_RootStyle;                    //!< 安全フレーム背景色
};

} // end of namespace glvapp
