﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <vector>
#include <nnt.h>
#include <nn/edid.h>
#include <nnt/edidUtil/testEdid_FullModeInfo.h>

typedef std::vector<nnt::edid::FullModeInfo> ModeList;

static const std::uint8_t s_pEdidRaw[] =
{
    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
    0x4D, 0xD9, 0x09, 0xEC, 0x00, 0x00, 0x00, 0x00,
    0x1B, 0x10, 0x01, 0x03, 0x80, 0x46, 0x28, 0x78,
    0x0A, 0x0D, 0xC9, 0xA0, 0x57, 0x47, 0x98, 0x27,
    0x12, 0x48, 0x4C, 0x20, 0x00, 0x00, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x3A,
    0x80, 0x18, 0x71, 0x38, 0x2D, 0x40, 0x58, 0x2C,
    0x45, 0x00, 0xDF, 0xA4, 0x21, 0x00, 0x00, 0x1E,
    0x01, 0x1D, 0x80, 0x18, 0x71, 0x1C, 0x16, 0x20,
    0x58, 0x2C, 0x25, 0x00, 0xDF, 0xA4, 0x21, 0x00,
    0x00, 0x9E, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x48,
    0x44, 0x4D, 0x49, 0x20, 0x4C, 0x4C, 0x43, 0x0A,
    0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0xFD,
    0x00, 0x3A, 0x3E, 0x0F, 0x46, 0x0F, 0x00, 0x0A,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0x83,

    0x02, 0x03, 0x3B, 0x71, 0x53, 0x94, 0x13, 0x05,
    0x03, 0x04, 0x11, 0x10, 0x1F, 0x20, 0x22, 0x3C,
    0x3E, 0x12, 0x02, 0x01, 0x16, 0x15, 0x07, 0x06,
    0x23, 0x09, 0x07, 0x07, 0x83, 0x01, 0x00, 0x00,
    0x73, 0x03, 0x0C, 0x00, 0x10, 0x00, 0xA8, 0x2D,
    0x2F, 0xC0, 0x08, 0x01, 0x41, 0x01, 0x12, 0x20,
    0x28, 0x10, 0x66, 0x00, 0x08, 0x10, 0x76, 0x96,
    0x90, 0xA0, 0xB0, 0x8C, 0x0A, 0xD0, 0x8A, 0x20,
    0xE0, 0x2D, 0x10, 0x10, 0x3E, 0x96, 0x00, 0xDF,
    0xA4, 0x21, 0x00, 0x00, 0x18, 0x8C, 0x0A, 0xD0,
    0x8A, 0x20, 0xE0, 0x2D, 0x10, 0x10, 0x3E, 0x96,
    0x00, 0x30, 0xA4, 0x21, 0x00, 0x00, 0x18, 0x8C,
    0x0A, 0xA0, 0x14, 0x51, 0xF0, 0x16, 0x00, 0x26,
    0x7C, 0x43, 0x00, 0x30, 0xA4, 0x21, 0x00, 0x00,
    0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCF,
};

TEST(AllContentTypes, DisplayInfo)
{
    nn::edid::Edid edid;
    ASSERT_EQ(nn::edid::Error_None, nn::edid::OpenEdid(&edid, s_pEdidRaw, sizeof(s_pEdidRaw)));

    nn::edid::DisplayInfo display;
    nn::edid::GetDisplayInfo(&display, &edid);

    EXPECT_STREQ("SNY", display.manufacturerCode);
    EXPECT_EQ(0xEC09, display.productCode);
    EXPECT_EQ(0, display.serialNumber);

    int date;
    EXPECT_TRUE(nn::edid::GetDisplayWeekOfManufacture(&date, &display));
    EXPECT_EQ(27, date);
    EXPECT_TRUE(nn::edid::GetDisplayYearOfManufacture(&date, &display));
    EXPECT_EQ(2006, date);

    EXPECT_EQ(nn::edid::VideoInterface_Digital, display.interfaceType);
    EXPECT_EQ(nn::edid::SyncLevel_Digital, display.sync);
    EXPECT_EQ(nn::edid::BlankLevel_Digital, display.blankType);

    EXPECT_EQ(nn::edid::ColorDepth_Undefined, display.depth);
    EXPECT_EQ(nn::edid::ColorType_Undefined, display.colorSupport);

    EXPECT_TRUE(display.contentTypes.IsAllOn());
    EXPECT_TRUE(display.syncTypes.IsAllOff());

    EXPECT_FALSE(display.isSrgbDefaultColorSpace);
    EXPECT_FALSE(display.isStandbyModeSupported);
    EXPECT_FALSE(display.isContinuousFrequency);
    EXPECT_FALSE(display.hasVsyncSerrations);
    EXPECT_FALSE(display.isStandbyModeSupported);
    EXPECT_FALSE(display.isSuspendModeSupported);
    EXPECT_FALSE(display.isVeryLowPowerSupported);
    EXPECT_FALSE(display.isYccQuantizationSelectable);
    EXPECT_FALSE(display.isRgbQuantizationSelectable);
}

TEST(AllContentTypes, GetSourcePhysicalAddress)
{
    nn::edid::Edid edid;
    ASSERT_EQ(nn::edid::Error_None, nn::edid::OpenEdid(&edid, s_pEdidRaw, sizeof(s_pEdidRaw)));

    std::uint16_t address;
    ASSERT_TRUE(nn::edid::GetSourcePhysicalAddress(&address, &edid));
    EXPECT_EQ(0x1000, address);
}
