﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testFixtures.h"

TEST_F(CurlTest, HttpBasicAuthTest)
{
    CURLcode cResult;
    nn::Result nResult;

    const char *testUrl = "http://natf.com/basic/basicauth.php";

    cResult = curl_easy_setopt(cHandle, CURLOPT_HTTPAUTH, CURLAUTH_BASIC | CURLAUTH_ONLY);
    ASSERT_EQ(CURLE_OK, cResult);

    // Set username and password for accessing the test page
    cResult = curl_easy_setopt(cHandle, CURLOPT_USERNAME, "ntdtestuser");
    ASSERT_EQ(CURLE_OK, cResult);

    cResult = curl_easy_setopt(cHandle, CURLOPT_PASSWORD, "hunter2");
    ASSERT_EQ(CURLE_OK, cResult);

    // Set the URL and send the request
    cResult = curl_easy_setopt(cHandle, CURLOPT_URL, testUrl);
    ASSERT_EQ(CURLE_OK, cResult);

    cResult = curl_easy_perform(cHandle);
    ASSERT_EQ(CURLE_OK, cResult);

    // Confirm the request was successful
    long responseCode;
    cResult = curl_easy_getinfo(cHandle, CURLINFO_RESPONSE_CODE, &responseCode);
    ASSERT_EQ(CURLE_OK, cResult);
    ASSERT_EQ(200, responseCode);
}

TEST_F(CurlTest, HttpDigestAuthTest)
{
    CURLcode cResult;
    nn::Result nResult;

    const char *testUrl = "http://natf.com/digest/digestauth.php";

    cResult = curl_easy_setopt(cHandle, CURLOPT_HTTPAUTH, CURLAUTH_DIGEST | CURLAUTH_ONLY);
    ASSERT_EQ(CURLE_OK, cResult);

    // Set username and password for accessing the test page
    cResult = curl_easy_setopt(cHandle, CURLOPT_USERPWD, "ntdtestuser:hunter2");
    ASSERT_EQ(CURLE_OK, cResult);

    // Set the URL and send the request
    cResult = curl_easy_setopt(cHandle, CURLOPT_URL, testUrl);
    ASSERT_EQ(CURLE_OK, cResult);

    cResult = curl_easy_perform(cHandle);
    ASSERT_EQ(CURLE_OK, cResult);

    // Confirm the request was successful
    long responseCode;
    cResult = curl_easy_getinfo(cHandle, CURLINFO_RESPONSE_CODE, &responseCode);
    ASSERT_EQ(CURLE_OK, cResult);
    ASSERT_EQ(200, responseCode);
}

TEST_F(CurlTest, HttpDigestIEAuthTest)
{
    CURLcode cResult;
    nn::Result nResult;

    const char *testUrl = "http://natf.com/digest/digestauth.php";

    cResult = curl_easy_setopt(cHandle, CURLOPT_HTTPAUTH, CURLAUTH_DIGEST_IE | CURLAUTH_ONLY);
    ASSERT_EQ(CURLE_OK, cResult);

    // Set username and password for accessing the test page
    cResult = curl_easy_setopt(cHandle, CURLOPT_USERPWD, "ntdtestuser:hunter2");
    ASSERT_EQ(CURLE_OK, cResult);

    // Set the URL and send the request
    cResult = curl_easy_setopt(cHandle, CURLOPT_URL, testUrl);
    ASSERT_EQ(CURLE_OK, cResult);

    cResult = curl_easy_perform(cHandle);
    ASSERT_EQ(CURLE_OK, cResult);

    // Confirm the request was successful
    long responseCode;
    cResult = curl_easy_getinfo(cHandle, CURLINFO_RESPONSE_CODE, &responseCode);
    ASSERT_EQ(CURLE_OK, cResult);
    ASSERT_EQ(200, responseCode);
}
