﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_Npad.h>
#include <nn/xcd/xcd.h>

namespace nnt { namespace xcd {

const nn::hid::NpadIdType SupportedNpadIds[] =
{
    nn::hid::NpadId::No1,
    nn::hid::NpadId::Handheld
};

const int SupportedNpadIdCount = NN_ARRAY_SIZE(SupportedNpadIds);

/*
 * Npad を初期化
 */
void InitializeNpad() NN_NOEXCEPT;

/*
 * NpadId から XCD ハンドルを取得
 */
nn::xcd::DeviceHandle GetXcdHandle(const nn::hid::NpadIdType& npadId) NN_NOEXCEPT;

/*
 * 指定した NpadId のボタン入力状態を取得
 */
nn::hid::NpadButtonSet GetButtonState(const nn::hid::NpadIdType& npadId) NN_NOEXCEPT;

/*
 * タグのプロトコルを表す文字列を取得
 */
const char* GetProtocolName(nn::xcd::NfcProtocol protocol) NN_NOEXCEPT;

/*
 * タグの種類を表す文字列を取得
 */
const char* GetTagTypeName(nn::xcd::NfcTagType type) NN_NOEXCEPT;

/*
 * イベント理由を表す文字列を取得
 */
const char* GetEventReasonName(nn::xcd::NfcEventReason reason) NN_NOEXCEPT;

}}  // nnt::xcd
