﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/xcd/xcd.h>
#pragma warning(push)
#pragma warning(disable: 4668)
#include <opencv2/opencv.hpp>
#pragma warning(pop)
#include "ProcessorTaskBase.h"

//============================================================
class DpdModeTestTask : public ProcessorTaskBase
{
public:
    DpdModeTestTask(const char* name, uptr arg)  // arg is unused. you can set NULL when you call the constructor.
    : ProcessorTaskBase(name, arg),
    m_PacketCnt(0),
    m_Config(),
    m_CurrentConfig()
    {
        for (auto i = 0; i < nn::xcd::IrDpdProcessorStateCountMax; i++)
        {
            m_State[i] = {0};
        }
    }

    virtual ~DpdModeTestTask()
    {}

public:
    enum
    {
        MENU_ITEM_DPD_WOI,
        MENU_ITEM_DPD_NUM
    };

    struct DpdConfig
    {
        nn::xcd::IrRect woi;
    };

    static const char* MENU_ITEM_DPD_NAMES[MENU_ITEM_DPD_NUM];

private:
    void DrawDpd( nn::xcd::IrDpdProcessorState& DpdProcessorState, IplImage* pResultImage);
    void SetDefaultDpdConfig(DpdConfig& config);
    void SaveData(IplImage* pImage, nn::xcd::IrDpdProcessorState& state, int index);

protected: // you have to implement
    virtual void DoInitializeCore();
    virtual void DoFinalizeCore();
    virtual void DoCalcCore(IplImage* pImage, IplImage* pDstImage);
    virtual void DoDrawCore(IplImage* pImage);
    virtual void DoDrawMenuCore(IplImage* pImage);
    virtual void DoCalcMenuCore(int* pMenuCnt);
    virtual void DoWriteRegSettingCore(nn::xcd::IrWriteRegisterSetting& setting, int& index);
    virtual void DoSetDefaultConfigCore(ProcessorConfig& config);
    virtual void DoCreateLogFileCore();
    virtual void DoCloseLogFileCore();

private:
    nn::xcd::IrDpdProcessorState m_State[nn::xcd::IrDpdProcessorStateCountMax];
    int m_PacketCnt;
    DpdConfig m_Config;
    DpdConfig m_CurrentConfig;
}; //DpdModeTestTask

//============================================================
