﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/xcd/xcd.h>

#include "testXcd_NfcPassThruAutoCommon.h"
#include "testXcd_NfcPassThruAutoFixture.h"

namespace nnt { namespace xcd {

// タグ検出のタイムアウト [msec]
const uint16_t DiscoveryTimeoutMsec = 5000;

// FeliCa コマンド送信のタイムアウト [msec]
const uint16_t FeliCaCommandTimeoutMsec = 100;

// FeliCa ポーリングコマンド
const nn::Bit8 FeliCaPollingCommand[] =
{
    0x06, 0x00,
    0xFF, 0xFF,     // システムコード (All)
    0x00,           // 要求データなし
    0x00            // 単一タグ想定のタイムスロット
};

// FeliCa ポーリング応答のサイズ
const size_t FelicaPollingResponseSize = 18;

// FeliCa ポーリング応答のヘッダ
// 後半は ID のため、先頭のみ確認する。
const nn::Bit8 FelicaPollingResponseHeader[] =
{
    0x12, 0x01
};

// Read Without Encryption コマンド
const nn::Bit8 ReadWithoutEncryptionCommand[] =
{
    0x10, 0x06,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // IDm (適切な値に差し替える)
    0x01,       // サービス数
    0x0B, 0x00, // サービスコード (0x000B = 認証不要の read)
    0x01,       // ブロック数
    0x80, 0x85  // 2 バイトブロックリスト指定でブロック 0x85 を読む
};

// Read Without Encryption コマンドの応答
// 実際はこの後にステータス + データが続くが、応答が取れていれば良いので先頭部分のみ見る。
const nn::Bit8 ReadWithoutEncryptionResponse[] =
{
    0x0C, 0x07,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   // IDm (適切な値に差し替える)
};

}}  // nnt::xcd
