﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/xcd/xcd.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>

#include "testXcd_NfcPassThruAutoCommon.h"
#include "testXcd_NfcPassThruAutoHelper.h"

namespace
{

// 初期化する Npad の ID リスト
const nn::hid::NpadIdType NpadIds[] =
{
    nn::hid::NpadId::No1,
    nn::hid::NpadId::Handheld
};

}  // anonymous

namespace nnt { namespace xcd {

void SetupNpad() NN_NOEXCEPT
{
    static bool s_IsConfigured = false;

    if (s_IsConfigured)
    {
        return;
    }

    // Npad の初期化
    nn::hid::InitializeNpad();
    nn::hid::SetSupportedNpadIdType(NpadIds, NN_ARRAY_SIZE(NpadIds));

    // 認識可能なスタイルを指定
    nn::hid::SetSupportedNpadStyleSet(
        nn::hid::NpadStyleFullKey::Mask
        | nn::hid::NpadStyleHandheld::Mask);

    for (const auto& id : NpadIds)
    {
        nn::hid::SetNpadJoyAssignmentModeSingle(id);
    }

    s_IsConfigured = true;
}

void PrintResult(nn::Result result) NN_NOEXCEPT
{
    if (result.IsSuccess())
    {
        NN_LOG("Success\n");
    }
    else if (nn::xcd::ResultNotConnected().Includes(result))
    {
        NN_LOG("NotConnected\n");
    }
    else if (nn::xcd::ResultInvalidMcuState().Includes(result))
    {
        NN_LOG("InvalidMcuState\n");
    }
    else if (nn::xcd::ResultMcuBusy().Includes(result))
    {
        NN_LOG("McuBusy\n");
    }
    else
    {
        NN_LOG("Unknown\n");
    }
}

}}  // nnt::xcd
