﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace TestAgent {

enum
{
    MODE_ID_MANUAL = 0,
    MODE_ID_TEST_AGENT,
    MODE_ID_NUM
};

class Arg
{
public :

    static const int MODE_NAME_SIZE = 16;
    static const int ARG_SIZE_MAX = 10;
    static const int ARG_STRING_LENGTH_MAX = 255;

private :

    int      m_Argc;
    char     m_Argv[ARG_SIZE_MAX][ARG_STRING_LENGTH_MAX];

    int      m_ModeId;

public :

    Arg();
    virtual ~Arg();

    void Initialize();
    void Initialize(int argc, char argv[ARG_SIZE_MAX][ARG_STRING_LENGTH_MAX]);
    bool Parse();

    int GetModeId(){ return m_ModeId; }
};
}
