﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "TA_program.h"
#include "TA_selector.h"

namespace TestAgent {

extern const char* APP_NAME;

const uint32_t SELECTOR_START_X  = 30;
const uint32_t SELECTOR_START_Y  = 80;
const uint32_t INFO_START_X      = 750;
const uint32_t INFO_START_Y      = 80;
const uint32_t DATA_START_X      = 15;
const uint32_t DATA_START_Y      = 180;
const uint32_t STATUSBAR_START_X = 15;
const uint32_t STATUSBAR_START_Y = 680;
const uint32_t TITLE_START_X     = 5;
const uint32_t MODE_START_X      = 300;
const uint32_t STATUS_OFFSET_X   = 910;

template<typename T>
void AddSelectorElement(SelectableValue<T>* sv, const T& value, const T& initialValue)
{
    sv->Add(value, value == initialValue);
}

template<typename T>
void AddSelectorElement(SelectableValue<NamedValue<T>>* sv, const string& text, const T& value, const T& initialValue)
{
    sv->Add(NamedValue<T>(text, value), value == initialValue);
}

void AddSelectorElement(SelectableValue<NamedValue<nn::TimeSpan> >* sv, const nn::TimeSpan& value, const nn::TimeSpan& initialValue);


/* Info page for test agent mode */
class AgentPage: public Application {
private:
    bool m_Selected;
    bool m_AgentMode;
    bool m_SettingErrorStandAlone;
    bool m_SettingErrorHostDriven;
    bool m_RunningErrorStandAlone;
    bool m_RunningErrorHostDriven;
    bool m_RunningErrorTestAgent;
    bool m_IsRunningStandAlone;
    bool m_IsRunningHostDriven;
    bool m_IsContinueTx;
    bool m_IsRunningTestAgent;
    bool m_IsDetectFetching;
    uint8_t  m_HashListBitMask[32];
    uint8_t  m_MacAddr[6];

    int  m_PageId;
    int  m_SingleSentCount;
    uint32_t m_CurrentDataLen;
    uint8_t  m_CurrentDataHash;
    uint8_t  m_CurrentDataCmd;

    Page m_InfoPage;
    Label m_Separator[2];
    Label m_BlankLine;
    Label m_Title;
    Label m_Help;

    Page m_StandAloneSetingPage;
    Label m_StandAloneSettingStatus;
    Label m_StandAloneInfo;

    Page m_StandAloneRunningPage;
    Label m_StandAloneRunningStatus;
    Label m_StandAloneRunningInfo;
    Label m_StandAloneRunningDataInfo;

    ValueSelector selectorStandAlone;

    SelectableValue<NamedValue<uint32_t> > m_SsTxInterval;
    SelectableValue<NamedValue<uint32_t> > m_SsTxCount;
    SelectableValue<NamedValue<uint32_t> > m_SsIdleCount;
    SelectableValue<NamedValue<uint32_t> > m_SsRxStart;
    SelectableValue<NamedValue<uint32_t> > m_SsRxCount;
    SelectableValue<NamedValue<uint32_t> > m_SsDataLength;
    SelectableValue<NamedValue<uint8_t> > m_SsDataHash;
    SelectableValue<NamedValue<uint8_t> > m_SsChannelNum;

    ValueSelector selectorStandAloneHashSet;
    SelectableValue<NamedValue<uint8_t> > m_SssHashFilter;

    Page m_HostDrivenSetingPage;
    Label m_HostDrivenSettingStatus;
    Label m_HostDrivenInfo;

    Page m_HostDrivenRunningPage;
    Label m_HostDrivenRunningStatus;
    Label m_HostDrivenRunningDataInfo;

    ValueSelector selectorHostDriven;

    SelectableValue<NamedValue<uint32_t> > m_HdTxInterval;
    SelectableValue<NamedValue<uint32_t> > m_HdTxCount;
    SelectableValue<NamedValue<uint32_t> > m_HdIdleCount;
    SelectableValue<NamedValue<uint32_t> > m_HdRxStart;
    SelectableValue<NamedValue<uint32_t> > m_HdRxCount;
    SelectableValue<NamedValue<uint32_t> > m_HdDataLength;
    SelectableValue<NamedValue<uint8_t> > m_HdChannelNum;
    SelectableValue<NamedValue<uint8_t> > m_HdDataHash;
    SelectableValue<NamedValue<bool> > m_HdIsSendPeriodical;

    ValueSelector selectorHostDrivenSendManually;
    SelectableValue<NamedValue<uint32_t> > m_HdSingleDataLength;
    SelectableValue<NamedValue<uint8_t> > m_HdSingleDataHash;
    SelectableValue<NamedValue<uint8_t> > m_HdSingleDataCmd;
    SelectableValue<NamedValue<uint32_t> > m_HdSingleTxInterval;

    Page m_TestAgentSetingPage;
    Label m_TestAgentSettingStatus;
    Label m_TestAgentInfo;

    Page m_TestAgentRunningPage;
    Label m_TestAgentRunningStatus;
    Label m_TestAgentRunningDataInfo;

private:
    void InitializeInfoPage(int PageId);
    void ShowCommonPageInfo(int PageId);
    void ShowSettingPageInfo(int PageId);
    void ShowExecutePageInfo(int PageId);
    void EnterExecutePageAction(int PageId);
    void LeaveExecutePageAction(int PageId);
    void UpdateSettingPage(int PageId);
    void UpdateExecutePageInfo(int PageId);
    void ButtonAExecutePageAction(int PageId);
    void ButtonXExecutePageAction(int PageId);
    void ButtonYExecutePageAction(int PageId);
    void ButtonPlusExecutePageAction(int PageId);
    void ShowAgentModePage();
    void InitializeStandAlonePage();
    void InitializeHostDrivenPage();

public:
    AgentPage();
    virtual ~AgentPage();
    virtual void ApplicationImpl();
    void SetAgentMode(bool mode) {m_AgentMode = mode;}
};
}
