﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_UuidApi.h>

#include <nn/nn_Log.h>

#include <nnt/nntest.h>

TEST(UtilUuid, Basic)
{
    // 100 個くらいは重複しないでほしい。
    const auto TestCount = 100;
    nn::util::Uuid history[TestCount];

    for (auto i = 0; i < TestCount; ++ i)
    {
        auto uuid = nn::util::GenerateUuid();

        ASSERT_EQ(0x4000, (static_cast<nn::Bit16>(uuid.data[6]) << 8 | uuid.data[7]) & 0xF000);   // 今生成されるのは Ver. 4 限定
        ASSERT_EQ(0x80, uuid.data[8] & 0xC0);   // reserved bits

        for (auto j = 0; j < i; ++ j)
        {
            if (history[j] == uuid)
            {
              NN_LOG("Info: uuid duplication detected, <%d,%d>.\n", j, i);
            }
        }
        history[i] = uuid;
    }
}
