﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#define NN_UTIL_CONFIG_VECTOR_MATRIX_TARGET NN_UTIL_CONFIG_VECTOR_MATRIX_TARGET_NEON

#include "testUtil_BenchmarkVectorApi.h"

// 必要な場合にのみ有効化する
#if false
namespace
{
    NN_NOINLINE float32x2_t Vector2fSinWrapper(float32x2_t vector)
    {
        return nn::util::neon::detail::Vector2fSin(vector);
    }

    NN_NOINLINE float32x2_t Vector2fCosWrapper(float32x2_t vector)
    {
        return nn::util::neon::detail::Vector2fCos(vector);
    }

    NN_NOINLINE void Vector2fSinCosWrapper(float32x2_t* pOutSin, float32x2_t* pOutCos, float32x2_t vector)
    {
        return nn::util::neon::detail::Vector2fSinCos(pOutSin, pOutCos, vector);
    }

    NN_NOINLINE float32x4_t Vector4fDivideWrapper(float32x4_t vector1, float32x4_t vector2)
    {
        return nn::util::neon::detail::Vector4fDivide(vector1, vector2);
    }

    NN_NOINLINE float32x4_t Vector4fSqrtWrapper(float32x4_t vector)
    {
        return nn::util::neon::detail::Vector4fSqrt(vector);
    }

    NN_NOINLINE float32x4_t Vector4fRoundWrapper(float32x4_t vector)
    {
        return nn::util::neon::detail::Vector4fRound(vector);
    }

    NN_NOINLINE float32x4_t Vector4fSinWrapper(float32x4_t vector)
    {
        return nn::util::neon::detail::Vector4fSin(vector);
    }

    NN_NOINLINE float32x4_t Vector4fCosWrapper(float32x4_t vector)
    {
        return nn::util::neon::detail::Vector4fCos(vector);
    }

    NN_NOINLINE void Vector4fSinCosWrapper(float32x4_t* pOutSin, float32x4_t* pOutCos, float32x4_t vector)
    {
        return nn::util::neon::detail::Vector4fSinCos(pOutSin, pOutCos, vector);
    }

    NN_NOINLINE float32x4_t Vector4fAtan2Wrapper(float32x4_t vectorY, float32x4_t vectorX)
    {
        return nn::util::neon::detail::Vector4fAtan2(vectorY, vectorX);
    }

    NN_NOINLINE float32x4_t Vector4fSelectWrapper(float32x4_t vector1, float32x4_t vector2, uint32x4_t select)
    {
        return nn::util::neon::detail::Vector4fSelect(vector1, vector2, select);
    }
}

BENCHMARK_VECTOR4(Vector2DetailNeonBenchmark, Sin)
{
    static float32x2_t vector = { 0, 1 };
    static float32x2_t result;

    while (state.KeepRunning()) {
        result = Vector2fSinWrapper(vector);
    }
}

BENCHMARK_VECTOR4(Vector2DetailNeonBenchmark, Cos)
{
    static float32x2_t vector = { 0, 1 };
    static float32x2_t result;

    while (state.KeepRunning()) {
        result = Vector2fCosWrapper(vector);
    }
}

BENCHMARK_VECTOR4(Vector2DetailNeonBenchmark, SinCos)
{
    static float32x2_t vector = { 0, 1 };
    static float32x2_t result1, result2;

    while (state.KeepRunning()) {
        Vector2fSinCosWrapper(&result1, &result2, vector);
    }
}

BENCHMARK_VECTOR4(Vector4DetailNeonBenchmark, Divide)
{
    static float32x4_t vector1 = { 0, 1, 2, 3 };
    static float32x4_t vector2 = { 1, 2, 3, 4 };
    static float32x4_t result;

    while (state.KeepRunning()) {
        result = Vector4fDivideWrapper(vector1, vector2);
    }
}

BENCHMARK_VECTOR4(Vector4DetailNeonBenchmark, Sqrd)
{
    static float32x4_t vector = { 0, 1, 2, 3 };
    static float32x4_t result;

    while (state.KeepRunning()) {
        result = Vector4fSqrtWrapper(vector);
    }
}

BENCHMARK_VECTOR4(Vector4DetailNeonBenchmark, Round)
{
    static float32x4_t vector = { 0, 1, 2, 3 };
    static float32x4_t result;

    while (state.KeepRunning()) {
        result = Vector4fRoundWrapper(vector);
    }
}

BENCHMARK_VECTOR4(Vector4DetailNeonBenchmark, Sin)
{
    static float32x4_t vector = { 0, 1, 2, 3 };
    static float32x4_t result;

    while (state.KeepRunning()) {
        result = Vector4fSinWrapper(vector);
    }
}

BENCHMARK_VECTOR4(Vector4DetailNeonBenchmark, Cos)
{
    static float32x4_t vector = { 0, 1, 2, 3 };
    static float32x4_t result;

    while (state.KeepRunning()) {
        result = Vector4fCosWrapper(vector);
    }
}

BENCHMARK_VECTOR4(Vector4DetailNeonBenchmark, SinCos)
{
    static float32x4_t vector = { 0, 1, 2, 3 };
    static float32x4_t result1, result2;

    while (state.KeepRunning()) {
        Vector4fSinCosWrapper(&result1, &result2, vector);
    }
}

BENCHMARK_VECTOR4(Vector4DetailNeonBenchmark, Atan2)
{
    static float32x4_t vector1 = { 0, 1, 2, 3 };
    static float32x4_t vector2 = { 1, 2, 3, 4 };
    static float32x4_t result;

    while (state.KeepRunning()) {
        result = Vector4fAtan2Wrapper(vector1, vector2);
    }
}

BENCHMARK_VECTOR4(Vector4DetailNeonBenchmark, Select)
{
    static float32x4_t vector1 = { 0, 1, 2, 3 };
    static float32x4_t vector2 = { 1, 2, 3, 4 };
    static uint32x4_t select = { 1, 1, 0, 0 };
    static float32x4_t result;

    while (state.KeepRunning()) {
        result = Vector4fSelectWrapper(vector1, vector2, select);
    }
}
#endif
