﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/benchmark/benchmark.h>
#include <nn/util/util_Arithmetic.h>

#include "Wrapper/testUtil_BenchmarkArithmeticWrapper.h"

#define BENCHMARK_ARITHMETIC_REGISTER(f_) \
        BENCHMARK(f_); \

#define BENCHMARK_ARITHMETIC(t_, f_) \
    void t_##_##f_(benchmark::State& state); \
    BENCHMARK_ARITHMETIC_REGISTER(t_##_##f_); \
    void t_##_##f_(benchmark::State& state)

#define BENCHMARK_WRAPPER_FUNC(f_) nn::util::f_##Wrapper

BENCHMARK_ARITHMETIC(ArithmeticBenchmark, Sin)
{
    static float radian = 0.1f;
    static float result;

    while (state.KeepRunning()) {
        result = BENCHMARK_WRAPPER_FUNC(SinEst)(radian);
    }
}

BENCHMARK_ARITHMETIC(ArithmeticBenchmark, Cos)
{
    static float radian = 0.1f;
    static float result;

    while (state.KeepRunning()) {
        result = BENCHMARK_WRAPPER_FUNC(CosEst)(radian);
    }
}

BENCHMARK_ARITHMETIC(ArithmeticBenchmark, SinCos)
{
    static float radian = 0.1f;
    static float result1, result2;

    while (state.KeepRunning()) {
        BENCHMARK_WRAPPER_FUNC(SinCosEst)(&result1, &result2, radian);
    }
}
