﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testUtil_BenchmarkVectorApiWrapper.neon.h"

namespace nn {
namespace util {
namespace neon {

Vector2fType MakeVector2fTypeWrapper(float x, float y)
{
    return MakeVector2fType(x, y);
}
void VectorLoadWrapper(Vector2fType* pOutValue, const float* pSource)
{
    return VectorLoad(pOutValue, pSource);
}
void VectorLoadWrapper(Vector2fType* pOutValue, const Float2& source)
{
    return VectorLoad(pOutValue, source);
}
void VectorStoreWrapper(float* pOutValue, const Vector2fType& source)
{
    return VectorStore(pOutValue, source);
}
void VectorStoreWrapper(Float2* pOutValue, const Vector2fType& source)
{
    return VectorStore(pOutValue, source);
}
void VectorSetWrapper(Vector2fType* pOutValue, float x, float y)
{
    return VectorSet(pOutValue, x, y);
}
void VectorSetXWrapper(Vector2fType* pOutValue, float value)
{
    return VectorSetX(pOutValue, value);
}
void VectorSetYWrapper(Vector2fType* pOutValue, float value)
{
    return VectorSetY(pOutValue, value);
}
float VectorGetXWrapper(const Vector2fType& vector)
{
    return VectorGetX(vector);
}
float VectorGetYWrapper(const Vector2fType& vector)
{
    return VectorGetY(vector);
}
void VectorZeroWrapper(Vector2fType* pOutValue)
{
    return VectorZero(pOutValue);
}
bool VectorIsZeroWrapper(const Vector2fType& vector)
{
    return VectorIsZero(vector);
}
bool VectorIsZeroWrapper(const Vector2fType& vector, float error)
{
    return VectorIsZero(vector, error);
}
void VectorAddWrapper(Vector2fType* pOutValue, const Vector2fType& vector1, const Vector2fType& vector2)
{
    return VectorAdd(pOutValue, vector1, vector2);
}
void VectorSubtractWrapper(Vector2fType* pOutValue, const Vector2fType& vector1, const Vector2fType& vector2)
{
    return VectorSubtract(pOutValue, vector1, vector2);
}
void VectorMultiplyWrapper(Vector2fType* pOutValue, const Vector2fType& vector, float factor)
{
    return VectorMultiply(pOutValue, vector, factor);
}
void VectorMultiplyWrapper(Vector2fType* pOutValue, const Vector2fType& vector1, const Vector2fType& vector2)
{
    return VectorMultiply(pOutValue, vector1, vector2);
}
void VectorDivideWrapper(Vector2fType* pOutValue, const Vector2fType& vector, float factor)
{
    return VectorDivide(pOutValue, vector, factor);
}
void VectorDivideWrapper(Vector2fType* pOutValue, const Vector2fType& vector1, const Vector2fType& vector2)
{
    return VectorDivide(pOutValue, vector1, vector2);
}
float VectorDotWrapper(const Vector2fType& vector1, const Vector2fType& vector2)
{
    return VectorDot(vector1, vector2);
}
float VectorCrossWrapper(const Vector2fType& vector1, const Vector2fType& vector2)
{
    return VectorCross(vector1, vector2);
}
float VectorLengthWrapper(const Vector2fType& vector)
{
    return VectorLength(vector);
}
float VectorLengthSquaredWrapper(const Vector2fType& vector)
{
    return VectorLengthSquared(vector);
}
float VectorDistanceWrapper(const Vector2fType& vector1, const Vector2fType& vector2)
{
    return VectorDistance(vector1, vector2);
}
float VectorDistanceSquaredWrapper(const Vector2fType& vector1, const Vector2fType& vector2)
{
    return VectorDistanceSquared(vector1, vector2);
}
float VectorNormalizeWrapper(Vector2fType* pOutValue, const Vector2fType& vector)
{
    return VectorNormalize(pOutValue, vector);
}
void VectorMaximizeWrapper(Vector2fType* pOutValue, const Vector2fType& vector1, const Vector2fType& vector2)
{
    return VectorMaximize(pOutValue, vector1, vector2);
}
void VectorMinimizeWrapper(Vector2fType* pOutValue, const Vector2fType& vector1, const Vector2fType& vector2)
{
    return VectorMinimize(pOutValue, vector1, vector2);
}
void VectorLerpWrapper(Vector2fType* pOutValue, const Vector2fType& from, const Vector2fType& to, float t)
{
    return VectorLerp(pOutValue, from, to, t);
}
void VectorTransformWrapper(Vector2fType* pOutValue, const Vector2fType& vector, const MatrixRowMajor3x2fType& matrix)
{
    return VectorTransform(pOutValue, vector, matrix);
}
void VectorTransformWrapper(Vector2fType* pOutValue, const Vector2fType& vector, const MatrixColumnMajor3x2fType& matrix)
{
    return VectorTransform(pOutValue, vector, matrix);
}
void VectorTransformNormalWrapper(Vector2fType* pOutValue, const Vector2fType& vector, const MatrixRowMajor3x2fType& matrix)
{
    return VectorTransformNormal(pOutValue, vector, matrix);
}
void VectorTransformNormalWrapper(Vector2fType* pOutValue, const Vector2fType& vector, const MatrixColumnMajor3x2fType& matrix)
{
    return VectorTransformNormal(pOutValue, vector, matrix);
}
Vector3fType MakeVector3fTypeWrapper(float x, float y, float z)
{
    return MakeVector3fType(x, y, z);
}
void VectorLoadWrapper(Vector3fType* pOutValue, const float* pSource)
{
    return VectorLoad(pOutValue, pSource);
}
void VectorLoadWrapper(Vector3fType* pOutValue, const Float3& source)
{
    return VectorLoad(pOutValue, source);
}
void VectorStoreWrapper(float* pOutValue, const Vector3fType& source)
{
    return VectorStore(pOutValue, source);
}
void VectorStoreWrapper(Float3* pOutValue, const Vector3fType& source)
{
    return VectorStore(pOutValue, source);
}
void VectorSetWrapper(Vector3fType* pOutValue, float x, float y, float z)
{
    return VectorSet(pOutValue, x, y, z);
}
void VectorSetXWrapper(Vector3fType* pOutValue, float value)
{
    return VectorSetX(pOutValue, value);
}
void VectorSetYWrapper(Vector3fType* pOutValue, float value)
{
    return VectorSetY(pOutValue, value);
}
void VectorSetZWrapper(Vector3fType* pOutValue, float value)
{
    return VectorSetZ(pOutValue, value);
}
float VectorGetXWrapper(const Vector3fType& vector)
{
    return VectorGetX(vector);
}
float VectorGetYWrapper(const Vector3fType& vector)
{
    return VectorGetY(vector);
}
float VectorGetZWrapper(const Vector3fType& vector)
{
    return VectorGetZ(vector);
}
void VectorZeroWrapper(Vector3fType* pOutValue)
{
    return VectorZero(pOutValue);
}
bool VectorIsZeroWrapper(const Vector3fType& vector)
{
    return VectorIsZero(vector);
}
bool VectorIsZeroWrapper(const Vector3fType& vector, float error)
{
    return VectorIsZero(vector, error);
}
void VectorAddWrapper(Vector3fType* pOutValue, const Vector3fType& vector1, const Vector3fType& vector2)
{
    return VectorAdd(pOutValue, vector1, vector2);
}
void VectorSubtractWrapper(Vector3fType* pOutValue, const Vector3fType& vector1, const Vector3fType& vector2)
{
    return VectorSubtract(pOutValue, vector1, vector2);
}
void VectorMultiplyWrapper(Vector3fType* pOutValue, const Vector3fType& vector, float factor)
{
    return VectorMultiply(pOutValue, vector, factor);
}
void VectorMultiplyWrapper(Vector3fType* pOutValue, const Vector3fType& vector1, const Vector3fType& vector2)
{
    return VectorMultiply(pOutValue, vector1, vector2);
}
void VectorDivideWrapper(Vector3fType* pOutValue, const Vector3fType& vector, float factor)
{
    return VectorDivide(pOutValue, vector, factor);
}
void VectorDivideWrapper(Vector3fType* pOutValue, const Vector3fType& vector1, const Vector3fType& vector2)
{
    return VectorDivide(pOutValue, vector1, vector2);
}
float VectorDotWrapper(const Vector3fType& vector1, const Vector3fType& vector2)
{
    return VectorDot(vector1, vector2);
}
void VectorCrossWrapper(Vector3fType* pOutValue, const Vector3fType& vector1, const Vector3fType& vector2)
{
    return VectorCross(pOutValue, vector1, vector2);
}
float VectorLengthWrapper(const Vector3fType& vector)
{
    return VectorLength(vector);
}
float VectorLengthSquaredWrapper(const Vector3fType& vector)
{
    return VectorLengthSquared(vector);
}
float VectorDistanceWrapper(const Vector3fType& vector1, const Vector3fType& vector2)
{
    return VectorDistance(vector1, vector2);
}
float VectorDistanceSquaredWrapper(const Vector3fType& vector1, const Vector3fType& vector2)
{
    return VectorDistanceSquared(vector1, vector2);
}
float VectorNormalizeWrapper(Vector3fType* pOutValue, const Vector3fType& vector)
{
    return VectorNormalize(pOutValue, vector);
}
void VectorMaximizeWrapper(Vector3fType* pOutValue, const Vector3fType& vector1, const Vector3fType& vector2)
{
    return VectorMaximize(pOutValue, vector1, vector2);
}
void VectorMinimizeWrapper(Vector3fType* pOutValue, const Vector3fType& vector1, const Vector3fType& vector2)
{
    return VectorMinimize(pOutValue, vector1, vector2);
}
void VectorLerpWrapper(Vector3fType* pOutValue, const Vector3fType& from, const Vector3fType& to, float t)
{
    return VectorLerp(pOutValue, from, to, t);
}
void VectorRotateWrapper(Vector3fType* pOutValue, const Vector3fType& vector, const Vector4fType& quaternion)
{
    return VectorRotate(pOutValue, vector, quaternion);
}
void VectorTransformWrapper(Vector3fType* pOutValue, const Vector3fType& vector, const MatrixRowMajor4x3fType& matrix)
{
    return VectorTransform(pOutValue, vector, matrix);
}
void VectorTransformWrapper(Vector3fType* pOutValue, const Vector3fType& vector, const MatrixColumnMajor4x3fType& matrix)
{
    return VectorTransform(pOutValue, vector, matrix);
}
void VectorTransformWrapper(Vector4fType* pOutValue, const Vector3fType& vector, const MatrixRowMajor4x4fType& matrix)
{
    return VectorTransform(pOutValue, vector, matrix);
}
void VectorTransformWrapper(Vector4fType* pOutValue, const Vector3fType& vector, const MatrixColumnMajor4x4fType& matrix)
{
    return VectorTransform(pOutValue, vector, matrix);
}
void VectorTransformNormalWrapper(Vector3fType* pOutValue, const Vector3fType& vector, const MatrixRowMajor4x3fType& matrix)
{
    return VectorTransformNormal(pOutValue, vector, matrix);
}
void VectorTransformNormalWrapper(Vector3fType* pOutValue, const Vector3fType& vector, const MatrixColumnMajor4x3fType& matrix)
{
    return VectorTransformNormal(pOutValue, vector, matrix);
}
void VectorTransformCoordWrapper(Vector3fType* pOutValue, const Vector3fType& vector, const MatrixRowMajor4x4fType& matrix)
{
    return VectorTransformCoord(pOutValue, vector, matrix);
}
void VectorTransformCoordWrapper(Vector3fType* pOutValue, const Vector3fType& vector, const MatrixColumnMajor4x4fType& matrix)
{
    return VectorTransformCoord(pOutValue, vector, matrix);
}
Vector4fType MakeVector4fTypeWrapper(float x, float y, float z, float w)
{
    return MakeVector4fType(x, y, z, w);
}
void VectorLoadWrapper(Vector4fType* pOutValue, const Uint8x4& source)
{
    return VectorLoad(pOutValue, source);
}
void VectorLoadWrapper(Vector4fType* pOutValue, const Unorm8x4& source)
{
    return VectorLoad(pOutValue, source);
}
void VectorLoadWrapper(Vector4fType* pOutValue, const float* pSource)
{
    return VectorLoad(pOutValue, pSource);
}
void VectorLoadWrapper(Vector4fType* pOutValue, const Float4& source)
{
    return VectorLoad(pOutValue, source);
}
void VectorStoreWrapper(Uint8x4* pOutValue, const Vector4fType& source)
{
    return VectorStore(pOutValue, source);
}
void VectorStoreWrapper(Unorm8x4* pOutValue, const Vector4fType& source)
{
    return VectorStore(pOutValue, source);
}
void VectorStoreWrapper(float* pOutValue, const Vector4fType& source)
{
    return VectorStore(pOutValue, source);
}
void VectorStoreWrapper(Float4* pOutValue, const Vector4fType& source)
{
    return VectorStore(pOutValue, source);
}
void VectorSetWrapper(Vector4fType* pOutValue, float x, float y, float z, float w)
{
    return VectorSet(pOutValue, x, y, z, w);
}
void VectorSetXWrapper(Vector4fType* pOutValue, float value)
{
    return VectorSetX(pOutValue, value);
}
void VectorSetYWrapper(Vector4fType* pOutValue, float value)
{
    return VectorSetY(pOutValue, value);
}
void VectorSetZWrapper(Vector4fType* pOutValue, float value)
{
    return VectorSetZ(pOutValue, value);
}
void VectorSetWWrapper(Vector4fType* pOutValue, float value)
{
    return VectorSetW(pOutValue, value);
}
float VectorGetXWrapper(const Vector4fType& vector)
{
    return VectorGetX(vector);
}
float VectorGetYWrapper(const Vector4fType& vector)
{
    return VectorGetY(vector);
}
float VectorGetZWrapper(const Vector4fType& vector)
{
    return VectorGetZ(vector);
}
float VectorGetWWrapper(const Vector4fType& vector)
{
    return VectorGetW(vector);
}
void VectorZeroWrapper(Vector4fType* pOutValue)
{
    return VectorZero(pOutValue);
}
bool VectorIsZeroWrapper(const Vector4fType& vector)
{
    return VectorIsZero(vector);
}
bool VectorIsZeroWOneWrapper(const Vector4fType& vector)
{
    return VectorIsZeroWOne(vector);
}
void VectorAddWrapper(Vector4fType* pOutValue, const Vector4fType& vector1, const Vector4fType& vector2)
{
    return VectorAdd(pOutValue, vector1, vector2);
}
void VectorSubtractWrapper(Vector4fType* pOutValue, const Vector4fType& vector1, const Vector4fType& vector2)
{
    return VectorSubtract(pOutValue, vector1, vector2);
}
void VectorMultiplyWrapper(Vector4fType* pOutValue, const Vector4fType& vector, float factor)
{
    return VectorMultiply(pOutValue, vector, factor);
}
void VectorMultiplyWrapper(Vector4fType* pOutValue, const Vector4fType& vector1, const Vector4fType& vector2)
{
    return VectorMultiply(pOutValue, vector1, vector2);
}
void VectorDivideWrapper(Vector4fType* pOutValue, const Vector4fType& vector, float factor)
{
    return VectorDivide(pOutValue, vector, factor);
}
void VectorDivideWrapper(Vector4fType* pOutValue, const Vector4fType& vector1, const Vector4fType& vector2)
{
    return VectorDivide(pOutValue, vector1, vector2);
}
float VectorDotWrapper(const Vector4fType& vector1, const Vector4fType& vector2)
{
    return VectorDot(vector1, vector2);
}
float VectorLengthWrapper(const Vector4fType& vector)
{
    return VectorLength(vector);
}
float VectorLengthSquaredWrapper(const Vector4fType& vector)
{
    return VectorLengthSquared(vector);
}
float VectorDistanceWrapper(const Vector4fType& vector1, const Vector4fType& vector2)
{
    return VectorDistance(vector1, vector2);
}
float VectorDistanceSquaredWrapper(const Vector4fType& vector1, const Vector4fType& vector2)
{
    return VectorDistanceSquared(vector1, vector2);
}
float VectorNormalizeWrapper(Vector4fType* pOutValue, const Vector4fType& vector)
{
    return VectorNormalize(pOutValue, vector);
}
void VectorMaximizeWrapper(Vector4fType* pOutValue, const Vector4fType& vector1, const Vector4fType& vector2)
{
    return VectorMaximize(pOutValue, vector1, vector2);
}
void VectorMinimizeWrapper(Vector4fType* pOutValue, const Vector4fType& vector1, const Vector4fType& vector2)
{
    return VectorMinimize(pOutValue, vector1, vector2);
}
void VectorLerpWrapper(Vector4fType* pOutValue, const Vector4fType& from, const Vector4fType& to, float t)
{
    return VectorLerp(pOutValue, from, to, t);
}
void VectorTransformWrapper(Vector4fType* pOutValue, const Vector4fType& vector, const MatrixRowMajor4x4fType& matrix)
{
    return VectorTransform(pOutValue, vector, matrix);
}
void VectorTransformWrapper(Vector4fType* pOutValue, const Vector4fType& vector, const MatrixColumnMajor4x4fType& matrix)
{
    return VectorTransform(pOutValue, vector, matrix);
}

}
}
}
