﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nnt/nntest.h>

#include <nn/util/util_MatrixApi.h>
#include <nn/util/util_Arithmetic.h>

#define NNT_UTIL_FLOAT_ROW_MAJOR_3X2_EXPECT_EQ(f_, m00_, m01_, m10_, m11_, m20_, m21_) \
    do{ \
        EXPECT_EQ( m00_, f_.m[0][0] ); EXPECT_EQ( m01_, f_.m[0][1] ); \
        EXPECT_EQ( m10_, f_.m[1][0] ); EXPECT_EQ( m11_, f_.m[1][1] ); \
        EXPECT_EQ( m20_, f_.m[2][0] ); EXPECT_EQ( m21_, f_.m[2][1] ); \
        }while(0)

#define NNT_UTIL_FLOAT_ROW_MAJOR_4X3_EXPECT_EQ(f_, m00_, m01_, m02_, m10_, m11_, m12_, m20_, m21_, m22_, m30_, m31_, m32_) \
    do{ \
        EXPECT_EQ( m00_, f_.m[0][0] ); EXPECT_EQ( m01_, f_.m[0][1] ); EXPECT_EQ( m02_, f_.m[0][2] ); \
        EXPECT_EQ( m10_, f_.m[1][0] ); EXPECT_EQ( m11_, f_.m[1][1] ); EXPECT_EQ( m12_, f_.m[1][2] ); \
        EXPECT_EQ( m20_, f_.m[2][0] ); EXPECT_EQ( m21_, f_.m[2][1] ); EXPECT_EQ( m22_, f_.m[2][2] ); \
        EXPECT_EQ( m30_, f_.m[3][0] ); EXPECT_EQ( m31_, f_.m[3][1] ); EXPECT_EQ( m32_, f_.m[3][2] ); \
        }while(0)

#define NNT_UTIL_FLOAT_ROW_MAJOR_4X4_EXPECT_EQ(f_, m00_, m01_, m02_, m03_, m10_, m11_, m12_, m13_, m20_, m21_, m22_, m23_, m30_, m31_, m32_, m33_) \
    do{ \
        EXPECT_EQ( m00_, f_.m[0][0] ); EXPECT_EQ( m01_, f_.m[0][1] ); EXPECT_EQ( m02_, f_.m[0][2] ); EXPECT_EQ( m03_, f_.m[0][3] ); \
        EXPECT_EQ( m10_, f_.m[1][0] ); EXPECT_EQ( m11_, f_.m[1][1] ); EXPECT_EQ( m12_, f_.m[1][2] ); EXPECT_EQ( m13_, f_.m[1][3] ); \
        EXPECT_EQ( m20_, f_.m[2][0] ); EXPECT_EQ( m21_, f_.m[2][1] ); EXPECT_EQ( m22_, f_.m[2][2] ); EXPECT_EQ( m23_, f_.m[2][3] ); \
        EXPECT_EQ( m30_, f_.m[3][0] ); EXPECT_EQ( m31_, f_.m[3][1] ); EXPECT_EQ( m32_, f_.m[3][2] ); EXPECT_EQ( m33_, f_.m[3][3] ); \
        }while(0)

#define NNT_UTIL_FLOAT_COLUMN_MAJOR_3X2_EXPECT_EQ(f_, m00_, m01_, m10_, m11_, m20_, m21_) \
    do{ \
        EXPECT_EQ( m00_, f_.m[0][0] ); EXPECT_EQ( m10_, f_.m[0][1] ); EXPECT_EQ( m20_, f_.m[0][2] ); \
        EXPECT_EQ( m01_, f_.m[1][0] ); EXPECT_EQ( m11_, f_.m[1][1] ); EXPECT_EQ( m21_, f_.m[1][2] ); \
        }while(0)

#define NNT_UTIL_FLOAT_COLUMN_MAJOR_4X3_EXPECT_EQ(f_, m00_, m01_, m02_, m10_, m11_, m12_, m20_, m21_, m22_, m30_, m31_, m32_) \
    do{ \
        EXPECT_EQ( m00_, f_.m[0][0] ); EXPECT_EQ( m10_, f_.m[0][1] ); EXPECT_EQ( m20_, f_.m[0][2] ); EXPECT_EQ( m30_, f_.m[0][3] ); \
        EXPECT_EQ( m01_, f_.m[1][0] ); EXPECT_EQ( m11_, f_.m[1][1] ); EXPECT_EQ( m21_, f_.m[1][2] ); EXPECT_EQ( m31_, f_.m[1][3] ); \
        EXPECT_EQ( m02_, f_.m[2][0] ); EXPECT_EQ( m12_, f_.m[2][1] ); EXPECT_EQ( m22_, f_.m[2][2] ); EXPECT_EQ( m32_, f_.m[2][3] ); \
        }while(0)

#define NNT_UTIL_FLOAT_COLUMN_MAJOR_4X4_EXPECT_EQ(f_, m00_, m01_, m02_, m03_, m10_, m11_, m12_, m13_, m20_, m21_, m22_, m23_, m30_, m31_, m32_, m33_) \
    do{ \
        EXPECT_EQ( m00_, f_.m[0][0] ); EXPECT_EQ( m10_, f_.m[0][1] ); EXPECT_EQ( m20_, f_.m[0][2] ); EXPECT_EQ( m30_, f_.m[0][3] ); \
        EXPECT_EQ( m01_, f_.m[1][0] ); EXPECT_EQ( m11_, f_.m[1][1] ); EXPECT_EQ( m21_, f_.m[1][2] ); EXPECT_EQ( m31_, f_.m[1][3] ); \
        EXPECT_EQ( m02_, f_.m[2][0] ); EXPECT_EQ( m12_, f_.m[2][1] ); EXPECT_EQ( m22_, f_.m[2][2] ); EXPECT_EQ( m32_, f_.m[2][3] ); \
        EXPECT_EQ( m03_, f_.m[3][0] ); EXPECT_EQ( m13_, f_.m[3][1] ); EXPECT_EQ( m23_, f_.m[3][2] ); EXPECT_EQ( m33_, f_.m[3][3] ); \
        }while(0)

#define NNT_UTIL_FLOAT_3X2_EXPECT_EQ NNT_UTIL_FLOAT_ROW_MAJOR_3X2_EXPECT_EQ
#define NNT_UTIL_FLOAT_4X3_EXPECT_EQ NNT_UTIL_FLOAT_ROW_MAJOR_4X3_EXPECT_EQ
#define NNT_UTIL_FLOAT_4X4_EXPECT_EQ NNT_UTIL_FLOAT_ROW_MAJOR_4X4_EXPECT_EQ

#define NNT_UTIL_FLOAT_T3X2_EXPECT_EQ NNT_UTIL_FLOAT_COLUMN_MAJOR_3X2_EXPECT_EQ
#define NNT_UTIL_FLOAT_T4X3_EXPECT_EQ NNT_UTIL_FLOAT_COLUMN_MAJOR_4X3_EXPECT_EQ
#define NNT_UTIL_FLOAT_T4X4_EXPECT_EQ NNT_UTIL_FLOAT_COLUMN_MAJOR_4X4_EXPECT_EQ

#if NN_UTIL_CONFIG_VECTOR_MATRIX_TARGET_IS_GENERAL

    #define NNT_UTIL_MATRIX_3X2_EXPECT_EQ(matrix_, m00_, m01_, m10_, m11_, m20_, m21_) \
        do{ \
            nn::util::FloatRowMajor3x2 f_; \
            nn::util::MatrixStore(&f_, matrix_); \
            EXPECT_EQ( m00_, f_.m[0][0] ); EXPECT_EQ( m01_, f_.m[0][1] ); \
            EXPECT_EQ( m10_, f_.m[1][0] ); EXPECT_EQ( m11_, f_.m[1][1] ); \
            EXPECT_EQ( m20_, f_.m[2][0] ); EXPECT_EQ( m21_, f_.m[2][1] ); \
            }while(0)

    #define NNT_UTIL_MATRIX_3X2_EXPECT_NEARLY_EQ(matrix_, m00_, m01_, m10_, m11_, m20_, m21_, error_) \
        do{ \
            nn::util::FloatRowMajor3x2 f_; \
            nn::util::MatrixStore(&f_, matrix_); \
            EXPECT_PRED3(nn::util::AreEqual, m00_, f_.m[0][0], error_); EXPECT_PRED3(nn::util::AreEqual, m01_, f_.m[0][1], error_); \
            EXPECT_PRED3(nn::util::AreEqual, m10_, f_.m[1][0], error_); EXPECT_PRED3(nn::util::AreEqual, m11_, f_.m[1][1], error_); \
            EXPECT_PRED3(nn::util::AreEqual, m20_, f_.m[2][0], error_); EXPECT_PRED3(nn::util::AreEqual, m21_, f_.m[2][1], error_); \
            }while(0)

    #define NNT_UTIL_MATRIX_4X3_EXPECT_EQ(matrix_, m00_, m01_, m02_, m10_, m11_, m12_, m20_, m21_, m22_, m30_, m31_, m32_) \
        do{ \
            nn::util::FloatRowMajor4x3 f_; \
            nn::util::MatrixStore(&f_, matrix_); \
            EXPECT_EQ( m00_, f_.m[0][0] ); EXPECT_EQ( m01_, f_.m[0][1] ); EXPECT_EQ( m02_, f_.m[0][2] ); \
            EXPECT_EQ( m10_, f_.m[1][0] ); EXPECT_EQ( m11_, f_.m[1][1] ); EXPECT_EQ( m12_, f_.m[1][2] ); \
            EXPECT_EQ( m20_, f_.m[2][0] ); EXPECT_EQ( m21_, f_.m[2][1] ); EXPECT_EQ( m22_, f_.m[2][2] ); \
            EXPECT_EQ( m30_, f_.m[3][0] ); EXPECT_EQ( m31_, f_.m[3][1] ); EXPECT_EQ( m32_, f_.m[3][2] ); \
            }while(0)

    #define NNT_UTIL_MATRIX_4X3_EXPECT_NEARLY_EQ(matrix_, m00_, m01_, m02_, m10_, m11_, m12_, m20_, m21_, m22_, m30_, m31_, m32_, error_) \
        do{ \
            nn::util::FloatRowMajor4x3 f_; \
            nn::util::MatrixStore(&f_, matrix_); \
            EXPECT_PRED3(nn::util::AreEqual, m00_, f_.m[0][0], error_); EXPECT_PRED3(nn::util::AreEqual, m01_, f_.m[0][1], error_); EXPECT_PRED3(nn::util::AreEqual, m02_, f_.m[0][2], error_); \
            EXPECT_PRED3(nn::util::AreEqual, m10_, f_.m[1][0], error_); EXPECT_PRED3(nn::util::AreEqual, m11_, f_.m[1][1], error_); EXPECT_PRED3(nn::util::AreEqual, m12_, f_.m[1][2], error_); \
            EXPECT_PRED3(nn::util::AreEqual, m20_, f_.m[2][0], error_); EXPECT_PRED3(nn::util::AreEqual, m21_, f_.m[2][1], error_); EXPECT_PRED3(nn::util::AreEqual, m22_, f_.m[2][2], error_); \
            EXPECT_PRED3(nn::util::AreEqual, m30_, f_.m[3][0], error_); EXPECT_PRED3(nn::util::AreEqual, m31_, f_.m[3][1], error_); EXPECT_PRED3(nn::util::AreEqual, m32_, f_.m[3][2], error_); \
            }while(0)

    #define NNT_UTIL_MATRIX_4X4_EXPECT_EQ(matrix_, m00_, m01_, m02_, m03_, m10_, m11_, m12_, m13_, m20_, m21_, m22_, m23_, m30_, m31_, m32_, m33_) \
        do{ \
            nn::util::FloatRowMajor4x4 f_; \
            nn::util::MatrixStore(&f_, matrix_); \
            EXPECT_EQ( m00_, f_.m[0][0] ); EXPECT_EQ( m01_, f_.m[0][1] ); EXPECT_EQ( m02_, f_.m[0][2] ); EXPECT_EQ( m03_, f_.m[0][3] ); \
            EXPECT_EQ( m10_, f_.m[1][0] ); EXPECT_EQ( m11_, f_.m[1][1] ); EXPECT_EQ( m12_, f_.m[1][2] ); EXPECT_EQ( m13_, f_.m[1][3] ); \
            EXPECT_EQ( m20_, f_.m[2][0] ); EXPECT_EQ( m21_, f_.m[2][1] ); EXPECT_EQ( m22_, f_.m[2][2] ); EXPECT_EQ( m23_, f_.m[2][3] ); \
            EXPECT_EQ( m30_, f_.m[3][0] ); EXPECT_EQ( m31_, f_.m[3][1] ); EXPECT_EQ( m32_, f_.m[3][2] ); EXPECT_EQ( m33_, f_.m[3][3] ); \
            }while(0)

    #define NNT_UTIL_MATRIX_4X4_EXPECT_NEARLY_EQ(matrix_, m00_, m01_, m02_, m03_, m10_, m11_, m12_, m13_, m20_, m21_, m22_, m23_, m30_, m31_, m32_, m33_, error_) \
        do{ \
            nn::util::FloatRowMajor4x4 f_; \
            nn::util::MatrixStore(&f_, matrix_); \
            EXPECT_PRED3(nn::util::AreEqual, m00_, f_.m[0][0], error_); EXPECT_PRED3(nn::util::AreEqual, m01_, f_.m[0][1], error_); EXPECT_PRED3(nn::util::AreEqual, m02_, f_.m[0][2], error_); EXPECT_PRED3(nn::util::AreEqual, m03_, f_.m[0][3], error_); \
            EXPECT_PRED3(nn::util::AreEqual, m10_, f_.m[1][0], error_); EXPECT_PRED3(nn::util::AreEqual, m11_, f_.m[1][1], error_); EXPECT_PRED3(nn::util::AreEqual, m12_, f_.m[1][2], error_); EXPECT_PRED3(nn::util::AreEqual, m13_, f_.m[1][3], error_); \
            EXPECT_PRED3(nn::util::AreEqual, m20_, f_.m[2][0], error_); EXPECT_PRED3(nn::util::AreEqual, m21_, f_.m[2][1], error_); EXPECT_PRED3(nn::util::AreEqual, m22_, f_.m[2][2], error_); EXPECT_PRED3(nn::util::AreEqual, m23_, f_.m[2][3], error_); \
            EXPECT_PRED3(nn::util::AreEqual, m30_, f_.m[3][0], error_); EXPECT_PRED3(nn::util::AreEqual, m31_, f_.m[3][1], error_); EXPECT_PRED3(nn::util::AreEqual, m32_, f_.m[3][2], error_); EXPECT_PRED3(nn::util::AreEqual, m33_, f_.m[3][3], error_); \
            }while(0)

#elif NN_UTIL_CONFIG_VECTOR_MATRIX_TARGET_IS_NEON

    namespace nnt { namespace util {

        struct FloatRowMajor4x2
        {
            float m[4][2];
        };

        NN_FORCEINLINE void MatrixStore(FloatRowMajor4x2* pOutValue, nn::util::MatrixRowMajor3x2fType matrix) NN_NOEXCEPT
        {
            nn::util::neon::detail::Vector2fStore(pOutValue->m[0], matrix._m.val[0]);
            nn::util::neon::detail::Vector2fStore(pOutValue->m[1], matrix._m.val[1]);
            nn::util::neon::detail::Vector2fStore(pOutValue->m[2], matrix._m.val[2]);
            nn::util::neon::detail::Vector2fStore(pOutValue->m[3], nn::util::neon::detail::Vector2fZero());
        }

        NN_FORCEINLINE void MatrixStore(FloatRowMajor4x2* pOutValue, nn::util::MatrixColumnMajor3x2fType matrix) NN_NOEXCEPT
        {
            float32x4x2_t vZip = vzipq_f32(matrix._m.val[0], matrix._m.val[1]);

            nn::util::neon::detail::Vector2fStore(pOutValue->m[0], vget_low_f32(vZip.val[0]));
            nn::util::neon::detail::Vector2fStore(pOutValue->m[1], vget_high_f32(vZip.val[0]));
            nn::util::neon::detail::Vector2fStore(pOutValue->m[2], vget_low_f32(vZip.val[1]));
            nn::util::neon::detail::Vector2fStore(pOutValue->m[3], vget_high_f32(vZip.val[1]));
        }

        NN_FORCEINLINE void MatrixStore(nn::util::FloatRowMajor4x4* pOutValue, nn::util::MatrixRowMajor4x3fType matrix) NN_NOEXCEPT
        {
            nn::util::neon::detail::MatrixRowMajor4x4fStore(pOutValue, matrix._m);
        }

        NN_FORCEINLINE void MatrixStore(nn::util::FloatRowMajor4x4* pOutValue, nn::util::MatrixColumnMajor4x3fType matrix) NN_NOEXCEPT
        {
            float32x4x4_t value;
            value.val[0] = matrix._m.val[0];
            value.val[1] = matrix._m.val[1];
            value.val[2] = matrix._m.val[2];
            value.val[3] = nn::util::neon::detail::Vector4fZero();
            value = nn::util::neon::detail::MatrixColumnMajor4x4fTranspose(value);

            nn::util::neon::detail::MatrixRowMajor4x4fStore(pOutValue, value);
        }
    }}


    #define NNT_UTIL_MATRIX_3X2_EXPECT_EQ(matrix_, m00_, m01_, m10_, m11_, m20_, m21_) \
        do{ \
            nnt::util::FloatRowMajor4x2 f_; \
            nnt::util::MatrixStore(&f_, matrix_); \
            EXPECT_EQ( m00_, f_.m[0][0] ); EXPECT_EQ( m01_, f_.m[0][1] ); \
            EXPECT_EQ( m10_, f_.m[1][0] ); EXPECT_EQ( m11_, f_.m[1][1] ); \
            EXPECT_EQ( m20_, f_.m[2][0] ); EXPECT_EQ( m21_, f_.m[2][1] ); \
            EXPECT_EQ( 0, f_.m[3][0] ); EXPECT_EQ( 0, f_.m[3][1] ); \
        }while(0)

    #define NNT_UTIL_MATRIX_3X2_EXPECT_NEARLY_EQ(matrix_, m00_, m01_, m10_, m11_, m20_, m21_, error_) \
        do{ \
            nnt::util::FloatRowMajor4x2 f_; \
            nnt::util::MatrixStore(&f_, matrix_); \
            EXPECT_PRED3(nn::util::AreEqual, m00_, f_.m[0][0], error_); EXPECT_PRED3(nn::util::AreEqual, m01_, f_.m[0][1], error_); \
            EXPECT_PRED3(nn::util::AreEqual, m10_, f_.m[1][0], error_); EXPECT_PRED3(nn::util::AreEqual, m11_, f_.m[1][1], error_); \
            EXPECT_PRED3(nn::util::AreEqual, m20_, f_.m[2][0], error_); EXPECT_PRED3(nn::util::AreEqual, m21_, f_.m[2][1], error_); \
            EXPECT_EQ( 0, f_.m[3][0] ); EXPECT_EQ( 0, f_.m[3][1] ); \
        }while(0)

    #define NNT_UTIL_MATRIX_4X3_EXPECT_EQ(matrix_, m00_, m01_, m02_, m10_, m11_, m12_, m20_, m21_, m22_, m30_, m31_, m32_) \
        do{ \
            nn::util::FloatRowMajor4x4 f_; \
            nnt::util::MatrixStore(&f_, matrix_); \
            EXPECT_EQ( m00_, f_.m[0][0] ); EXPECT_EQ( m01_, f_.m[0][1] ); EXPECT_EQ( m02_, f_.m[0][2] ); EXPECT_EQ( 0, f_.m[0][3] ); \
            EXPECT_EQ( m10_, f_.m[1][0] ); EXPECT_EQ( m11_, f_.m[1][1] ); EXPECT_EQ( m12_, f_.m[1][2] ); EXPECT_EQ( 0, f_.m[1][3] ); \
            EXPECT_EQ( m20_, f_.m[2][0] ); EXPECT_EQ( m21_, f_.m[2][1] ); EXPECT_EQ( m22_, f_.m[2][2] ); EXPECT_EQ( 0, f_.m[2][3] ); \
            EXPECT_EQ( m30_, f_.m[3][0] ); EXPECT_EQ( m31_, f_.m[3][1] ); EXPECT_EQ( m32_, f_.m[3][2] ); EXPECT_EQ( 0, f_.m[3][3] ); \
        }while(0)

    #define NNT_UTIL_MATRIX_4X3_EXPECT_NEARLY_EQ(matrix_, m00_, m01_, m02_, m10_, m11_, m12_, m20_, m21_, m22_, m30_, m31_, m32_, error_) \
        do{ \
            nn::util::FloatRowMajor4x4 f_; \
            nnt::util::MatrixStore(&f_, matrix_); \
            EXPECT_PRED3(nn::util::AreEqual, m00_, f_.m[0][0], error_); EXPECT_PRED3(nn::util::AreEqual, m01_, f_.m[0][1], error_); EXPECT_PRED3(nn::util::AreEqual, m02_, f_.m[0][2], error_); EXPECT_EQ( 0, f_.m[0][3] ); \
            EXPECT_PRED3(nn::util::AreEqual, m10_, f_.m[1][0], error_); EXPECT_PRED3(nn::util::AreEqual, m11_, f_.m[1][1], error_); EXPECT_PRED3(nn::util::AreEqual, m12_, f_.m[1][2], error_); EXPECT_EQ( 0, f_.m[1][3] ); \
            EXPECT_PRED3(nn::util::AreEqual, m20_, f_.m[2][0], error_); EXPECT_PRED3(nn::util::AreEqual, m21_, f_.m[2][1], error_); EXPECT_PRED3(nn::util::AreEqual, m22_, f_.m[2][2], error_); EXPECT_EQ( 0, f_.m[2][3] ); \
            EXPECT_PRED3(nn::util::AreEqual, m30_, f_.m[3][0], error_); EXPECT_PRED3(nn::util::AreEqual, m31_, f_.m[3][1], error_); EXPECT_PRED3(nn::util::AreEqual, m32_, f_.m[3][2], error_); EXPECT_EQ( 0, f_.m[3][3] ); \
        }while(0)

    #define NNT_UTIL_MATRIX_4X4_EXPECT_EQ(matrix_, m00_, m01_, m02_, m03_, m10_, m11_, m12_, m13_, m20_, m21_, m22_, m23_, m30_, m31_, m32_, m33_) \
        do{ \
            nn::util::FloatRowMajor4x4 f_; \
            nn::util::MatrixStore(&f_, matrix_); \
            EXPECT_EQ( m00_, f_.m[0][0] ); EXPECT_EQ( m01_, f_.m[0][1] ); EXPECT_EQ( m02_, f_.m[0][2] ); EXPECT_EQ( m03_, f_.m[0][3] ); \
            EXPECT_EQ( m10_, f_.m[1][0] ); EXPECT_EQ( m11_, f_.m[1][1] ); EXPECT_EQ( m12_, f_.m[1][2] ); EXPECT_EQ( m13_, f_.m[1][3] ); \
            EXPECT_EQ( m20_, f_.m[2][0] ); EXPECT_EQ( m21_, f_.m[2][1] ); EXPECT_EQ( m22_, f_.m[2][2] ); EXPECT_EQ( m23_, f_.m[2][3] ); \
            EXPECT_EQ( m30_, f_.m[3][0] ); EXPECT_EQ( m31_, f_.m[3][1] ); EXPECT_EQ( m32_, f_.m[3][2] ); EXPECT_EQ( m33_, f_.m[3][3] ); \
        }while(0)

    #define NNT_UTIL_MATRIX_4X4_EXPECT_NEARLY_EQ(matrix_, m00_, m01_, m02_, m03_, m10_, m11_, m12_, m13_, m20_, m21_, m22_, m23_, m30_, m31_, m32_, m33_, error_) \
        do{ \
            nn::util::FloatRowMajor4x4 f_; \
            nn::util::MatrixStore(&f_, matrix_); \
            EXPECT_PRED3(nn::util::AreEqual, m00_, f_.m[0][0], error_); EXPECT_PRED3(nn::util::AreEqual, m01_, f_.m[0][1], error_); EXPECT_PRED3(nn::util::AreEqual, m02_, f_.m[0][2], error_); EXPECT_PRED3(nn::util::AreEqual, m03_, f_.m[0][3], error_); \
            EXPECT_PRED3(nn::util::AreEqual, m10_, f_.m[1][0], error_); EXPECT_PRED3(nn::util::AreEqual, m11_, f_.m[1][1], error_); EXPECT_PRED3(nn::util::AreEqual, m12_, f_.m[1][2], error_); EXPECT_PRED3(nn::util::AreEqual, m13_, f_.m[1][3], error_); \
            EXPECT_PRED3(nn::util::AreEqual, m20_, f_.m[2][0], error_); EXPECT_PRED3(nn::util::AreEqual, m21_, f_.m[2][1], error_); EXPECT_PRED3(nn::util::AreEqual, m22_, f_.m[2][2], error_); EXPECT_PRED3(nn::util::AreEqual, m23_, f_.m[2][3], error_); \
            EXPECT_PRED3(nn::util::AreEqual, m30_, f_.m[3][0], error_); EXPECT_PRED3(nn::util::AreEqual, m31_, f_.m[3][1], error_); EXPECT_PRED3(nn::util::AreEqual, m32_, f_.m[3][2], error_); EXPECT_PRED3(nn::util::AreEqual, m33_, f_.m[3][3], error_); \
        }while(0)

#else
    #error   "未サポートのターゲットが指定されています。"
#endif
