﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>

#include <nn/util/util_IFunction.h>

#include <nn/nn_Common.h>

namespace {

using nn::util::IFunction;
using nn::util::MakeIFunction;

int Invoke(int x, int y, const IFunction<int (int, int)>& f)
{
    return f(x, y);
}

TEST(testUtil_IFunction, MakeIFunction)
{
    {
        EXPECT_EQ(3, Invoke(1, 2, MakeIFunction([](int x, int y) { return x + y; })));
    }
    {
        auto f = [](int x, int y) { return x + y; };
        EXPECT_EQ(3, Invoke(1, 2, MakeIFunction(f)));
    }
    {
        int v = 0;
        auto f = [&v](int x, int y)
        {
            ++v;
            return x + y + v;
        };
        EXPECT_EQ(4, Invoke(1, 2, MakeIFunction(f)));
        EXPECT_EQ(5, Invoke(1, 2, MakeIFunction(f)));
        auto g = [&v](int x, int y)
        {
            ++v;
            return x + y + v;
        };
        EXPECT_EQ(6, Invoke(1, 2, MakeIFunction(g)));
        EXPECT_EQ(3, v);
    }
    {
        int v = 0;
        auto f = [v](int x, int y) mutable
        {
            ++v;
            return x + y + v;
        };
        EXPECT_EQ(4, Invoke(1, 2, MakeIFunction(std::ref(f))));
        EXPECT_EQ(5, Invoke(1, 2, MakeIFunction(std::ref(f))));
        EXPECT_EQ(0, v);
    }
    {
        struct F
        {
            int v = 0;
            int operator()(int x, int y) const
            {
                return x + y + v;
            }
        };
        F f;
        f.v = 10;
        EXPECT_EQ(13, Invoke(1, 2, MakeIFunction(f)));
        EXPECT_EQ(13, Invoke(1, 2, MakeIFunction(f)));
        EXPECT_EQ(10, f.v);
    }
    {
        struct F
        {
            int v = 0;
            int operator()(int x, int y) const
            {
                return x + y + v;
            }
        };
        F f;
        f.v = 10;
        const auto ifun = MakeIFunction(f);
        EXPECT_EQ(13, Invoke(1, 2, ifun));
        EXPECT_EQ(13, Invoke(1, 2, ifun));
        EXPECT_EQ(10, f.v);
    }
    {
        struct F
        {
            mutable int v = 0;
            int operator()(int x, int y) const
            {
                ++v;
                return x + y + v;
            }
        };
        F f;
        const auto ifun = MakeIFunction(f);
        EXPECT_EQ(4, Invoke(1, 2, ifun));
        EXPECT_EQ(5, Invoke(1, 2, ifun));
        EXPECT_EQ(0, f.v);
    }
    {
        struct F
        {
            int v = 0;
            int operator()(int x, int y)
            {
                ++v;
                return x + y + v;
            }
        };
        F f;
        EXPECT_EQ(4, Invoke(1, 2, MakeIFunction(std::ref(f))));
        EXPECT_EQ(5, Invoke(1, 2, MakeIFunction(std::ref(f))));
        EXPECT_EQ(2, f.v);
    }
    {
        struct F
        {
            int v = 0;
            int operator()(int x, int y)
            {
                ++v;
                return x + y + v;
            }
        };
        F f;
        auto ifun = MakeIFunction(std::ref(f));
        EXPECT_EQ(4, Invoke(1, 2, ifun));
        EXPECT_EQ(5, Invoke(1, 2, ifun));
        EXPECT_EQ(2, f.v);
    }
} // NOLINT(impl/function_size)

}
