﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/util/util_BinTypes.h>

namespace {

TEST( BinVersionTest, BinVersion  )
{
    nn::util::BinVersion version;
    version.major = 0x1234;
    version.minor = 0x56;
    version.micro = 0x78;

    EXPECT_EQ( 0x12345678, version.GetPacked() );
    EXPECT_EQ( 0x12345678, NN_UTIL_CREATE_BINVERSION( 0x1234, 0x56, 0x78 ) );

    char data[4];
    memcpy( data, &version, 4);

    EXPECT_EQ( 0x78, data[0] );
    EXPECT_EQ( 0x56, data[1] );
    EXPECT_EQ( 0x34, data[2] );
    EXPECT_EQ( 0x12, data[3] );

    version.SetPacked( 0x78563412 );
    EXPECT_EQ( 0x78563412, version.GetPacked() );
    EXPECT_EQ( 0x78563412, NN_UTIL_CREATE_BINVERSION( 0x7856, 0x34, 0x12 ) );
}

} // anonymous namespace
