﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../UsbDiag_Theme.h"
#include "SceneSelector.h"

namespace nnt {
namespace usb {

SceneSelector::SceneSelector(const glv::Rect& rect)
    : RadioGroup(rect, 1)
{
    onStyle  = {
        MenuTextSize, MenuActiveTextColor,
        MenuActiveBackColor, MenuActiveBackColor, glv::Place::CL
    };
    offStyle = {
        MenuTextSize, MenuInactiveTextColor,
        MenuInactiveBackColor, MenuInactiveBackColor, glv::Place::CL
    };
}

SceneSelector&
SceneSelector::Add(Scene& scene)
{
    RadioGroup::Add(scene.GetName());
    m_Scenes.push_back(&scene);

    return *this;
}

void
SceneSelector::OnChange(int value)
{
    notify(this, glv::Update::Selection, m_Scenes[value]);
}

} // ~usb
} // ~nnt
