﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <glv_viewutility.h>
#include "Scene.h"

namespace nnt {
namespace usb {

std::stack<Scene*> Scene::m_Stack;

Scene::Scene(Stage& stage, const char *name) NN_NOEXCEPT
    : glv::ViewContainer(glv::Rect(stage.width(), stage.height()))
    , m_Stage(stage)
    , m_Name(name)
{
    enable(glv::Property::HitTest     |
           glv::Property::CropChildren);

    disable(glv::Property::FocusToTop |
            glv::Property::Visible    );

    stage.add(this);
}

bool Scene::onEvent(glv::Event::t e, glv::GLV& g)
{
    if (!glv::ViewContainer::onEvent(e, g))
    {
        return false;
    }

    int flags = glv::toMoveFlags(e, g);
    if( (flags & glv::MoveArrowMask) != 0 )
    {
        auto *view = focusableView();
        if (view)
        {
            g.setFocus(view);
            return false;
        }
    }

    return true;
}

void Scene::Enter() NN_NOEXCEPT
{
    // Exit current scene
    if (m_Stack.size())
    {
        m_Stack.top()->OnExit();
    }

    // Enter this scene
    m_Stack.push(this);
    OnEnter();
}

void Scene::Exit() NN_NOEXCEPT
{
    NN_ASSERT(m_Stack.size() && (m_Stack.top() == this));

    // Exit this scene
    OnExit();
    m_Stack.pop();

    // Enter previous scene
    if (m_Stack.size())
    {
        m_Stack.top()->OnEnter();
    }
}

void Scene::Replace() NN_NOEXCEPT
{
    NN_ASSERT(m_Stack.size());

    // Exit current scene
    m_Stack.top()->OnExit();
    m_Stack.pop();

    // Enter this scene
    m_Stack.push(this);
    OnEnter();
}

void Scene::OnEnter() NN_NOEXCEPT
{
    auto& g = static_cast< glv::GLV& >( this->root() );
    enable(glv::Property::Visible);

    auto *view = focusableView();
    g.setFocus(view ? view : this);
};

void Scene::OnExit() NN_NOEXCEPT
{
    disable(glv::Property::Visible);
}

} // ~usb
} // ~nnt
