﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

namespace nnt {
namespace usb {

class CheckBox : public glv::Group
{
public:
    typedef void (*OnCheckCallback)(bool checked);

    CheckBox(const char *caption, bool checked, OnCheckCallback onCheck);
    ~CheckBox();

    bool IsChecked();

    virtual void OnCheck();
    virtual const char *className() const NN_OVERRIDE { return "CheckBox"; };

private:
    glv::Placer     m_Placer;

    glv::Button     m_CheckBox;
    glv::Label      m_Caption;

    OnCheckCallback m_OnCheck;
};

} // ~usb
} // ~nnt
