﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/usb/usb_Host.h>
#include "UsbDiag_Theme.h"
#include "UsbDiag_TuningView.h"
#include "UsbDiag_UsbModel.h"

#include "widgets/RadioGroup.h"

namespace nnt {
namespace usb {

TuningView::TuningView(Stage& stage) NN_NOEXCEPT
    : Scene(stage, "Tuning")
    , m_Table("pp,pp,pp", 10, 20)
{
    disable(glv::Property::DrawBack   |
            glv::Property::Animate);

    m_Table.disable(glv::Property::HitTest);

    const glv::Label::Spec spec{glv::Place::TL, 0, 0, 25, false};

    m_pTestMode = new RadioGroup(
        {"TEST_J", "TEST_K", "TEST_SE0_NAK", "TEST_PACKET"},
        glv::Rect(220, 45),
        4
    );
    m_pDriveStrengthOffset = new RadioGroup(
        {"-1", "-2", "-3", "-4", "-5", "-6",
         "+1", "+2", "+3", "+4", "+5", "+6",
         "0"},
        glv::Rect(100, 45),
        6
    );

    auto driveStrength = new glv::Label("N/A", spec);

    m_pTestMode->attach(
        [](const glv::Notification& n) {
            auto *value = n.data<int>();
            static const nn::usb::TestMode mode[] = {
                nn::usb::TestMode_J,
                nn::usb::TestMode_K,
                nn::usb::TestMode_Se0Nak,
                nn::usb::TestMode_Packet,
            };
            NN_ASSERT(*value < 4);
            g_Model.SetTestMode(mode[*value]);
        },
        glv::Update::Value
    );
    m_pDriveStrengthOffset->attach(
        [](const glv::Notification& n) {
            auto *value = n.data<int>();
            static const int offset[] = {
                -1, -2, -3, -4, -5, -6,
                +1, +2, +3, +4, +5, +6,
                0,
            };
            g_Model.SetDriveStrengthOffset(offset[*value]);
        },
        glv::Update::Value
    );

    m_Table << new glv::Label("Drive Strength:", spec)
            << driveStrength
            << new glv::Label("Drive Strength Offset:", spec)
            << m_pDriveStrengthOffset
            << new glv::Label("Test Mode:", spec)
            << m_pTestMode;

    m_Table.arrange().pos(glv::Place::CC, width() / 2, height() / 2);

    add(m_Table);

    g_Model.attach(
        [](const glv::Notification& n) {
            auto *label    = n.receiver<glv::Label>();
            auto  strength = *n.data<uint32_t>();
            label->setValue(std::to_string(strength));
        },
        Event_UpdateDriveStrength,
        driveStrength
    );
}

TuningView::~TuningView() NN_NOEXCEPT
{
    // nothing special
}

} // ~usb
} // ~nnt
