﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

namespace nnt {
namespace usb {

//-----------------------------------------------------------------------------
// Button
//-----------------------------------------------------------------------------
const glv::space_t ButtonPaddingX = 10.f;
const glv::space_t ButtonPaddingY = 5.f;

//-----------------------------------------------------------------------------
// Font
//-----------------------------------------------------------------------------

const glv::space_t NormalFontSize = 20.f;
const glv::space_t NoticeFontSize = 50.f;

//-----------------------------------------------------------------------------
// RootView
//-----------------------------------------------------------------------------

const glv::space_t RootGap       = 10.f;  // y gap between ContentView and FooterView
const glv::space_t RootPaddingX  = 5.f;   // x padding to the screen edge
const glv::space_t RootPaddingY  = 5.f;   // y padding to the screen edge

//-----------------------------------------------------------------------------
// Menu
//-----------------------------------------------------------------------------

const glv::space_t MenuWidth        = 300.f;
const glv::space_t MenuEntryHeight  = 50.f;
const glv::space_t MenuTextSize     = 25.f;
const glv::Color   MenuActiveBackColor(0.5f);
const glv::Color   MenuActiveTextColor(0.1f);
const glv::Color   MenuInactiveBackColor(0.1f);
const glv::Color   MenuInactiveTextColor(0.9f);

//-----------------------------------------------------------------------------
// Footer
//-----------------------------------------------------------------------------

const glv::space_t FooterPaddingX = 20.f;
const glv::space_t FooterPaddingY = 15.f;
const glv::space_t FooterHeight   = 60.f;

//-----------------------------------------------------------------------------
// Content
//-----------------------------------------------------------------------------

const glv::space_t ContentGap = 10.f; // x gap between DeviceListView and DetailView

//-----------------------------------------------------------------------------
// EpView
//-----------------------------------------------------------------------------

const glv::space_t EpPaddingX = 5.f;
const glv::space_t EpPaddingY = 5.f;

//-----------------------------------------------------------------------------
// IfView
//-----------------------------------------------------------------------------

const glv::space_t IfPaddingX = 5.f;
const glv::space_t IfPaddingY = 5.f;

//-----------------------------------------------------------------------------
// DeviceView
//-----------------------------------------------------------------------------

const glv::space_t DevicePaddingX = 5.f;
const glv::space_t DevicePaddingY = 5.f;

//-----------------------------------------------------------------------------
// DeviceListView
//-----------------------------------------------------------------------------

const glv::space_t DeviceListGapX = 5.f;  // x gap between DeviceView and scroll bar
const glv::space_t DeviceListGapY = 10.f; // y gap between DeviceViews
const glv::space_t DeviceListScrollBarWidth = 15.f;

//-----------------------------------------------------------------------------
// DetailView
//-----------------------------------------------------------------------------

const glv::space_t DetailPaddingX       = 5.f;
const glv::space_t DetailPaddingY       = 5.f;
const glv::space_t DetailScrollBarWidth = 15.f;

//-----------------------------------------------------------------------------
// Geometry
//-----------------------------------------------------------------------------

const glv::space_t EpWidth           = 250.f;
const glv::space_t IfWidth           = 300.f + EpWidth;
const glv::space_t DeviceWidth       = 400.f + IfWidth;

const glv::space_t DeviceListWidth   = DeviceWidth + DeviceListGapX + DeviceListScrollBarWidth;

const glv::space_t AnimationSpeed    = 800.f;

} // ~usb
} // ~nnt
